/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network;

import fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network.INetworkNode;
import fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network.Network;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NetworkHandler {
    final Map<Address, Network> networkList = new HashMap<Address, Network>();

    public Network addNetwork(Level level, Address address) {
        Network network = new Network(level);
        this.networkList.put(address, network);
        return network;
    }

    public Network getNetOf(Level level, INetworkNode actor) {
        Address key = actor.getAddress();
        if (!this.networkList.containsKey(key)) {
            this.addNetwork(level, key);
        }
        return this.networkList.get(actor.getAddress());
    }

    public static class Address {
        public static final Address EMPTY = new Address(ItemStack.f_41583_);
        private static final Map<Item, Address> addresses = new IdentityHashMap<Item, Address>();
        private ItemStack stack;
        private Item item;

        public static Address of(ItemStack stack) {
            if (stack.m_41619_()) {
                return EMPTY;
            }
            if (!stack.m_41782_()) {
                return addresses.computeIfAbsent(stack.m_41720_(), $ -> new Address(stack));
            }
            return new Address(stack);
        }

        private Address(ItemStack stack) {
            this.stack = stack;
            this.item = stack.m_41720_();
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int hashCode() {
            return this.item.hashCode();
        }
    }
}

