/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import dev.architectury.platform.Platform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class IOUtils {
    public static InputStream readFile(String filePath) throws IOException {
        File file = new File(filePath);
        return new FileInputStream(file);
    }

    public static void saveInputStreamToFile(InputStream inputStream, String filePath) throws IOException {
        int bytesRead;
        File file = new File(filePath);
        FileOutputStream outputStream = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            ((OutputStream)outputStream).write(buffer, 0, bytesRead);
        }
        inputStream.close();
        ((OutputStream)outputStream).close();
    }

    public static void writeTextFile(String filePath, String content) throws IOException {
        Files.writeString(Path.of(filePath, new String[0]), (CharSequence)content, new OpenOption[0]);
    }

    public static String readTextFile(String filePath) throws IOException {
        byte[] fileBytes = Files.readAllBytes(Path.of(filePath, new String[0]));
        return new String(fileBytes, StandardCharsets.UTF_8);
    }

    public static InputStream byteArrayToInputStream(byte[] byteArray) {
        return new ByteArrayInputStream(byteArray);
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static boolean createDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            boolean created = directory.mkdirs();
            return created;
        }
        return false;
    }

    public static String[] getFileNames(String directoryPath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(directoryPath, new String[0]));){
            for (Path path : directoryStream) {
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                fileNames.add(path.getFileName().toString());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return fileNames.toArray(new String[0]);
    }

    public static String formatBytes(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public static String[] getFileNamesWithoutExtension(String directoryPath) {
        File[] files;
        ArrayList<String> fileNames = new ArrayList<String>();
        File directory = new File(directoryPath);
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                String fileName;
                int dotIndex;
                if (!file.isFile() || (dotIndex = (fileName = file.getName()).lastIndexOf(".")) == -1) continue;
                String fileNameWithoutExtension = fileName.substring(0, dotIndex);
                fileNames.add(fileNameWithoutExtension);
            }
        }
        return fileNames.toArray(new String[0]);
    }

    public static String getFileNameWithoutExtension(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0 && dotIndex < fileName.length() - 1) {
            return fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        return fileName.substring(lastDotIndex + 1);
    }

    public static boolean isValidFileName(String fileName) {
        String invalidCharsRegex = "[\\\\/:*?\"<>|]";
        Pattern pattern = Pattern.compile(invalidCharsRegex);
        return !pattern.matcher(fileName).find();
    }

    public static String sanitizeFileName(String fileName) {
        String invalidCharsRegex = "[\\\\/:*?\"<>|]";
        String sanitizedFileName = fileName.replaceAll(invalidCharsRegex, "");
        return sanitizedFileName;
    }

    public static String getFileHash(String filePath) {
        try {
            File file = new File(filePath);
            String data = file.getName() + file.length() + file.lastModified();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(data.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getConfigDirForMod(String modid) {
        return String.format("%s/%s", Platform.getConfigFolder(), modid);
    }

    public static String createConfigDirectory(String modid) {
        String path = IOUtils.getConfigDirForMod(modid);
        IOUtils.createDirectory(path);
        return path;
    }

    public static void writeConfigTextFile(String modid, String relFilePath, String content) throws IOException {
        String path = IOUtils.getConfigDirForMod(modid) + "/" + relFilePath;
        IOUtils.createDirectory(path);
        Files.writeString(Path.of(path, new String[0]), (CharSequence)content, new OpenOption[0]);
    }

    public static String readConfigTextFile(String modid, String relFilePath) throws IOException {
        byte[] fileBytes = Files.readAllBytes(Path.of(IOUtils.getConfigDirForMod(modid) + "/" + relFilePath, new String[0]));
        return new String(fileBytes, StandardCharsets.UTF_8);
    }
}

