/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class Wikipedia {
    protected static final String WIKIPEDIA_BASE_URL = "https://www.wikipedia.org/";
    protected static final Map<String, WikipediaArticle> articles = new HashMap<String, WikipediaArticle>();

    public static void addArticle(String ... articleId) {
        for (String id : articleId) {
            articles.put(id, new WikipediaArticle(id));
        }
    }

    public static WikipediaArticle getArticle(String id) {
        return articles.get(id);
    }

    public static Collection<WikipediaArticle> getArticles() {
        return articles.values();
    }

    public static class WikipediaArticle {
        protected boolean loadingFinished = false;
        protected String json;
        protected Map<String, String> articleLanguages = new HashMap<String, String>();
        protected String fallbackUrl = null;

        public WikipediaArticle(String articleId) {
            new Thread(() -> {
                Thread.currentThread().setName("Wikipedia Article Loader");
                try {
                    URL url = new URL(String.format("https://www.wikidata.org/w/api.php?action=wbgetentities&format=json&props=sitelinks&ids=%s", articleId));
                    Scanner scan = new Scanner(url.openStream());
                    Object str = "";
                    while (scan.hasNext()) {
                        str = (String)str + scan.nextLine();
                    }
                    scan.close();
                    this.extractSiteTitleMap((String)str, articleId);
                }
                catch (Exception e) {
                    DragonLib.LOGGER.warn("Could not get wikipedia article data.", (Throwable)e);
                }
                this.loadingFinished = true;
            }).start();
        }

        protected void extractSiteTitleMap(String jsonData, String entityId) {
            JsonObject jsonObject = (JsonObject)DragonLib.GSON.fromJson(jsonData, JsonObject.class);
            JsonObject entities = jsonObject.getAsJsonObject("entities");
            JsonObject entity = entities.getAsJsonObject(entityId);
            JsonObject sitelinks = entity.getAsJsonObject("sitelinks");
            HashMap<String, String> siteTitleMap = new HashMap<String, String>();
            Set entries = sitelinks.entrySet();
            for (Map.Entry entry : entries) {
                String site = (String)entry.getKey();
                JsonObject sitelink = ((JsonElement)entry.getValue()).getAsJsonObject();
                String title = sitelink.get("title").getAsString();
                siteTitleMap.put(site, title);
            }
            this.articleLanguages = siteTitleMap;
        }

        public boolean isLoaded() {
            return this.loadingFinished;
        }

        public void setFallbackUrl(String fallbackUrl) {
            this.fallbackUrl = fallbackUrl;
        }

        public String getFallbackUrl() {
            return this.fallbackUrl == null ? Wikipedia.WIKIPEDIA_BASE_URL : this.fallbackUrl;
        }

        public String getArticleUrl(String language) {
            String langId = String.format("%swiki", language);
            String url = this.getFallbackUrl();
            if (this.articleLanguages.containsKey(langId)) {
                url = String.format("https://%s.wikipedia.org/wiki/%s", language, this.articleLanguages.get(langId));
            } else if (this.articleLanguages.containsKey("enwiki")) {
                url = String.format("https://en.wikipedia.org/wiki/%s", language, this.articleLanguages.get("enwiki"));
            } else if (this.articleLanguages.size() > 0) {
                Map.Entry firstEntry = (Map.Entry)this.articleLanguages.entrySet().stream().findFirst().get();
                url = String.format("https://%s.wikipedia.org/wiki/%s", ((String)firstEntry.getKey()).replace("wiki", ""), firstEntry.getValue());
            }
            return url.replace(" ", "_");
        }
    }
}

