/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;

public class PowerLevelPacket {
    private int powerLevel;

    public PowerLevelPacket() {
    }

    public PowerLevelPacket(int powerLevel) {
        this.powerLevel = powerLevel;
    }

    public static void encode(PowerLevelPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.powerLevel);
    }

    public static PowerLevelPacket decode(FriendlyByteBuf buf) {
        return new PowerLevelPacket(buf.readInt());
    }

    public static class Handler {
        public static void handle(final PowerLevelPacket message, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            if (context.getDirection().getReceptionSide().isClient()) {
                context.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        LocalPlayer player = Minecraft.m_91087_().f_91074_;
                        if (player != null) {
                            player.getCapability(CapabilityHandler.POWER_LEVEL_CAPABILITY, null).ifPresent(levelCap -> levelCap.setPowerLevel(message2.powerLevel));
                        }
                    }
                });
            }
            context.setPacketHandled(true);
        }
    }
}

