/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import rbasamoyai.escalated.config.EscalatedConfigs;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockEntities;
import rbasamoyai.escalated.index.EscalatedTriggers;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwayMovementHandler;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public abstract class AbstractWalkwayBlock
extends HorizontalKineticBlock
implements IBE<WalkwayBlockEntity>,
WalkwayBlock {
    private final NonNullSupplier<WalkwaySet> walkwaySetSupplier;
    private WalkwaySet walkwaySet = null;

    protected AbstractWalkwayBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties);
        this.walkwaySetSupplier = walkwaySetSupplier;
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_(HORIZONTAL_FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122427_().m_122434_();
    }

    public Class<WalkwayBlockEntity> getBlockEntityClass() {
        return WalkwayBlockEntity.class;
    }

    public BlockEntityType<? extends WalkwayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EscalatedBlockEntities.WALKWAY.get();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.transportEntity(level, pos, state, entity);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        BlockPos actualPos = entity.m_20097_();
        BlockState actualState = level.m_8055_(actualPos);
        this.transportEntity(level, actualPos, actualState, entity);
    }

    protected void transportEntity(Level level, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).m_6144_() || player.m_150110_().f_35935_)) {
            return;
        }
        if (((Boolean)EscalatedConfigs.SERVER.divingBootsPreventWalkwayMotion.get()).booleanValue() && DivingBootsItem.isWornBy((Entity)entity)) {
            return;
        }
        WalkwayBlockEntity walkway = WalkwayHelper.getSegmentBE((LevelAccessor)level, pos);
        if (walkway == null) {
            return;
        }
        WalkwayBlockEntity controller = WalkwayHelper.getControllerBE((LevelAccessor)level, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entity)) {
            WalkwayMovementHandler.TransportedEntityInfo info = controller.passengers.get(entity);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entity.m_20183_())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entity, new WalkwayMovementHandler.TransportedEntityInfo(pos, state));
            entity.m_6853_(true);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        block32: {
            boolean connectedRight;
            boolean connectedLeft;
            Direction left;
            block31: {
                Direction facing = this.getFacing(state);
                left = facing.m_122428_();
                connectedLeft = this.connectedToWalkwayOnSide(level, state, pos, left);
                connectedRight = this.connectedToWalkwayOnSide(level, state, pos, left.m_122424_());
                super.m_6810_(state, level, pos, newState, isMoving);
                if (level.f_46443_ || state.m_60734_() == newState.m_60734_() || this.getWalkwaySet().blockInSet(newState) || isMoving) {
                    return;
                }
                WalkwayBlock walkwayBlock = this;
                BlockState currentState = state;
                for (Direction dir : Iterate.directionsInAxis((Direction.Axis)left.m_122434_())) {
                    WalkwayBlockEntity sideWalkwayBE;
                    WalkwayBlock sideWalkway;
                    BlockPos sidePos = pos.m_121945_(dir);
                    BlockState sideState = level.m_8055_(sidePos);
                    Block block = sideState.m_60734_();
                    if (!(block instanceof WalkwayBlock) || !(sideWalkway = (WalkwayBlock)block).connectedToWalkwayOnSide(level, sideState, sidePos, dir.m_122424_())) continue;
                    boolean sideShaft = sideWalkway.hasWalkwayShaft(sideState);
                    BlockState transformState = sideWalkway.transformFromMerge(level, sideState, sidePos, dir != left, sideShaft, true, false);
                    DyeColor color = null;
                    float visualProgress = 0.0f;
                    BlockEntity blockEntity = level.m_7702_(sidePos);
                    if (blockEntity instanceof WalkwayBlockEntity) {
                        sideWalkwayBE = (WalkwayBlockEntity)blockEntity;
                        color = sideWalkwayBE.getColor();
                        visualProgress = sideWalkwayBE.getVisualProgress();
                    }
                    KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)sidePos, (BlockState)transformState);
                    blockEntity = level.m_7702_(sidePos);
                    if (!(blockEntity instanceof WalkwayBlockEntity)) continue;
                    sideWalkwayBE = (WalkwayBlockEntity)blockEntity;
                    sideWalkwayBE.applyColor(color);
                    sideWalkwayBE.setVisualProgress(visualProgress);
                    sideWalkwayBE.resetClientRender = true;
                    sideWalkwayBE.notifyUpdate();
                }
                boolean terminal = this.getWalkwaySlope(state) == WalkwaySlope.TERMINAL;
                for (boolean forward : Iterate.trueAndFalse) {
                    WalkwayBlock newWalkway;
                    Block sideShaft;
                    BlockPos currentPos = WalkwayBlock.nextSegmentPosition(state, pos, forward, terminal && !forward);
                    if (currentPos == null || !((sideShaft = (currentState = level.m_8055_(currentPos)).m_60734_()) instanceof WalkwayBlock)) continue;
                    walkwayBlock = newWalkway = (WalkwayBlock)sideShaft;
                    boolean hasPulley = walkwayBlock.hasWalkwayShaft(currentState);
                    level.m_46747_(currentPos);
                    Object shaftState = (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)this.getRotationAxis(currentState));
                    level.m_7731_(currentPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((boolean[])(hasPulley ? shaftState : (boolean[])Blocks.f_50016_.m_49966_())), (BlockPos)currentPos), 3);
                    level.m_46796_(2001, currentPos, Block.m_49956_((BlockState)currentState));
                }
                BlockPos abovePos = pos.m_7494_();
                BlockState aboveState = level.m_8055_(abovePos);
                if (!(aboveState.m_60734_() instanceof AbstractHandrailBlock)) break block31;
                AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)aboveState.m_61143_(AbstractHandrailBlock.SIDE));
                if (side == AbstractHandrailBlock.Side.BOTH) {
                    level.m_46961_(abovePos, true);
                } else {
                    Direction offsetDir;
                    ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                    positions.add(abovePos);
                    BlockPos iterPos = abovePos;
                    BlockState iterState = aboveState;
                    int MAX_ITER = 1100;
                    for (boolean forward : Iterate.trueAndFalse) {
                        iterPos = abovePos;
                        iterState = aboveState;
                        for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.m_8055_(iterPos)).m_60734_() instanceof AbstractHandrailBlock; ++i) {
                            positions.add(iterPos);
                        }
                    }
                    BlockEntity color = level.m_7702_(abovePos);
                    if (!(color instanceof HandrailBlockEntity)) {
                        return;
                    }
                    HandrailBlockEntity handrailBE = (HandrailBlockEntity)color;
                    int handrailWidth = handrailBE.width;
                    Direction handrailLeft = ((Direction)aboveState.m_61143_((Property)AbstractHandrailBlock.f_54117_)).m_122428_();
                    Direction direction = offsetDir = side == AbstractHandrailBlock.Side.LEFT ? handrailLeft.m_122424_() : handrailLeft;
                    if (handrailWidth == 2) {
                        for (BlockPos handrailPos : positions) {
                            BlockPos newHandrailPos = handrailPos.m_121945_(offsetDir);
                            BlockState oldHandrailState = level.m_8055_(newHandrailPos);
                            if (!(oldHandrailState.m_60734_() instanceof AbstractHandrailBlock)) continue;
                            level.m_7731_(newHandrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)oldHandrailState.m_61124_(AbstractHandrailBlock.SIDE, (Comparable)((Object)AbstractHandrailBlock.Side.BOTH))), (BlockPos)newHandrailPos), 3);
                            BlockEntity blockEntity = level.m_7702_(handrailPos);
                            if (blockEntity instanceof HandrailBlockEntity) {
                                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)blockEntity;
                                handrailBE1.propagateBreak = false;
                            }
                            level.m_7731_(handrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.f_50016_.m_49966_(), (BlockPos)handrailPos), 3);
                            level.m_46796_(2001, handrailPos, Block.m_49956_((BlockState)oldHandrailState));
                        }
                    } else {
                        BlockPos newHandrailPos;
                        for (BlockPos handrailPos : positions) {
                            newHandrailPos = handrailPos.m_121945_(offsetDir);
                            if (level.m_8055_(newHandrailPos).m_247087_()) continue;
                            level.m_46961_(abovePos, true);
                            return;
                        }
                        for (BlockPos handrailPos : positions) {
                            newHandrailPos = handrailPos.m_121945_(offsetDir);
                            BlockState placeState = level.m_8055_(handrailPos);
                            level.m_46961_(newHandrailPos, true);
                            level.m_7731_(newHandrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)placeState, (BlockPos)newHandrailPos), 3);
                            BlockEntity blockEntity = level.m_7702_(newHandrailPos);
                            if (blockEntity instanceof HandrailBlockEntity) {
                                HandrailBlockEntity newHandrailBE = (HandrailBlockEntity)blockEntity;
                                blockEntity = level.m_7702_(handrailPos);
                                if (blockEntity instanceof HandrailBlockEntity) {
                                    HandrailBlockEntity oldHandrailBE = (HandrailBlockEntity)blockEntity;
                                    newHandrailBE.width = handrailWidth - 1;
                                    oldHandrailBE.width = 0;
                                    oldHandrailBE.propagateBreak = false;
                                    BlockEntity blockEntity2 = level.m_7702_(newHandrailPos.m_5484_(offsetDir, handrailWidth - 1));
                                    if (blockEntity2 instanceof HandrailBlockEntity) {
                                        HandrailBlockEntity oppositeHandrailBE = (HandrailBlockEntity)blockEntity2;
                                        oppositeHandrailBE.width = newHandrailBE.width;
                                    }
                                }
                            }
                            level.m_7731_(handrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.f_50016_.m_49966_(), (BlockPos)handrailPos), 3);
                            level.m_46796_(2001, abovePos, Block.m_49956_((BlockState)placeState));
                        }
                    }
                }
                break block32;
            }
            if (!connectedLeft || !connectedRight) break block32;
            for (Direction dir : Iterate.directionsInAxis((Direction.Axis)left.m_122434_())) {
                BlockEntity newHandrailPos;
                BlockPos abovePos1;
                BlockState aboveState1;
                int offset;
                int MAX_ITER = 256;
                BlockPos offsetPos = pos.m_5484_(dir, offset);
                BlockState offsetState = level.m_8055_(offsetPos);
                for (offset = 1; offset < MAX_ITER; ++offset) {
                    offsetPos = pos.m_5484_(dir, offset);
                    offsetState = level.m_8055_(offsetPos);
                    Block i = offsetState.m_60734_();
                    if (!(i instanceof WalkwayBlock)) {
                        return;
                    }
                    WalkwayBlock offsetWalkway = (WalkwayBlock)i;
                    if (!offsetWalkway.connectedToWalkwayOnSide(level, offsetState, offsetPos, dir)) break;
                }
                if (!((aboveState1 = level.m_8055_(abovePos1 = offsetPos.m_7494_())).m_60734_() instanceof AbstractHandrailBlock) || !((newHandrailPos = level.m_7702_(abovePos1)) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)newHandrailPos;
                if (handrailBE.width == offset) continue;
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                positions.add(abovePos1);
                for (boolean forward : Iterate.trueAndFalse) {
                    BlockPos iterPos = abovePos1;
                    BlockState iterState = aboveState1;
                    for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.m_8055_(iterPos)).m_60734_() instanceof AbstractHandrailBlock; ++i) {
                        positions.add(iterPos);
                    }
                }
                if (offset > 1) {
                    boolean fail = false;
                    for (BlockPos handrailPos : positions) {
                        BlockPos otherHandrailPos = handrailPos.m_5484_(dir, -offset + 1);
                        if (level.m_8055_(otherHandrailPos).m_247087_()) continue;
                        fail = true;
                        break;
                    }
                    if (fail) {
                        for (BlockPos handrailPos : positions) {
                            BlockEntity i = level.m_7702_(handrailPos);
                            if (i instanceof HandrailBlockEntity) {
                                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)i;
                                handrailBE1.propagateBreak = false;
                            }
                            level.m_46961_(handrailPos, true);
                        }
                        continue;
                    }
                    for (BlockPos handrailPos : positions) {
                        BlockEntity i = level.m_7702_(handrailPos);
                        if (i instanceof HandrailBlockEntity) {
                            HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)i;
                            handrailBE1.width = offset;
                        }
                        BlockState srcHandrailState = level.m_8055_(handrailPos);
                        BlockPos otherHandrailPos = handrailPos.m_5484_(dir, -offset + 1);
                        level.m_46961_(otherHandrailPos, true);
                        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)srcHandrailState.m_61143_(AbstractHandrailBlock.SIDE));
                        AbstractHandrailBlock.Side placeSide = side == AbstractHandrailBlock.Side.LEFT ? AbstractHandrailBlock.Side.RIGHT : AbstractHandrailBlock.Side.LEFT;
                        level.m_7731_(otherHandrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)srcHandrailState.m_61124_(AbstractHandrailBlock.SIDE, (Comparable)((Object)placeSide))), (BlockPos)otherHandrailPos), 3);
                        BlockEntity blockEntity = level.m_7702_(otherHandrailPos);
                        if (!(blockEntity instanceof HandrailBlockEntity)) continue;
                        HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)blockEntity;
                        handrailBE1.width = offset;
                    }
                    continue;
                }
                for (BlockPos handrailPos : positions) {
                    BlockState handrailState = level.m_8055_(handrailPos);
                    level.m_7731_(handrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)handrailState.m_61124_(AbstractHandrailBlock.SIDE, (Comparable)((Object)AbstractHandrailBlock.Side.BOTH))), (BlockPos)handrailPos), 3);
                    BlockEntity blockEntity = level.m_7702_(handrailPos);
                    if (!(blockEntity instanceof HandrailBlockEntity)) continue;
                    HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)blockEntity;
                    handrailBE1.width = 1;
                }
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        if (this.hasWalkwayShaft(state)) {
            drops.addAll(AllBlocks.SHAFT.getDefaultState().m_287290_(builder));
        }
        return drops;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        boolean isDye = WalkwayHelper.isDye(heldItem);
        boolean hasWater = WalkwayHelper.hasWater(level, heldItem);
        if (isDye || hasWater) {
            return this.onBlockEntityUse((BlockGetter)level, pos, be -> be.applyColor(WalkwayHelper.getDyeColorFromItem(heldItem)) ? InteractionResult.SUCCESS : InteractionResult.PASS);
        }
        boolean isBelt = WalkwayHelper.isHandrail(heldItem);
        if (isBelt) {
            return this.placeHandrail(level, state, pos, player, heldItem) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean placeHandrail(Level level, BlockState state, BlockPos pos, Player player, ItemStack itemStack) {
        BlockEntity leftPos;
        BlockPos centralPos = pos;
        BlockState referenceState = state;
        if (this.getWalkwaySlope(referenceState) == WalkwaySlope.TERMINAL && !((referenceState = level.m_8055_(centralPos = pos.m_121945_(this.getFacing(referenceState)))).m_60734_() instanceof WalkwayBlock)) {
            return false;
        }
        WalkwayBlock walkway = (WalkwayBlock)referenceState.m_60734_();
        Direction dir = walkway.getFacing(referenceState);
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)walkway.getWalkwaySet().getHandrailBlock(level, referenceState, centralPos).m_60734_();
        int MAX_ITER = 1100;
        if (!walkway.connectedToWalkwayOnSide(level, referenceState, pos, dir.m_122427_()) && !walkway.connectedToWalkwayOnSide(level, referenceState, pos, dir.m_122428_())) {
            void var17_25;
            if (level.m_8055_(centralPos.m_7494_()).m_60734_() instanceof AbstractHandrailBlock) {
                return false;
            }
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            BlockState iterState = referenceState;
            BlockPos iterPos = centralPos;
            positions.add(iterPos);
            Object object = Iterate.trueAndFalse;
            int n = ((boolean[])object).length;
            boolean bl = false;
            while (var17_25 < n) {
                boolean forward = object[var17_25];
                iterState = referenceState;
                iterPos = centralPos;
                for (int i = 0; i < MAX_ITER && (iterPos = WalkwayBlock.nextSegmentPosition(iterState, iterPos, forward, true)) != null; ++i) {
                    iterState = level.m_8055_(iterPos);
                    if (!(iterState.m_60734_() instanceof WalkwayBlock) || !level.m_8055_(iterPos.m_7494_()).m_247087_()) {
                        return false;
                    }
                    positions.add(iterPos);
                }
                ++var17_25;
            }
            object = positions.iterator();
            while (object.hasNext()) {
                BlockPos basePos = (BlockPos)object.next();
                BlockState blockState = level.m_8055_(basePos);
                WalkwayBlock otherWalkway = (WalkwayBlock)blockState.m_60734_();
                BlockPos abovePos = basePos.m_7494_();
                BlockState placeState = handrail.getStateForSlope(level, basePos, blockState, abovePos, dir, otherWalkway.getWalkwaySlope(blockState), AbstractHandrailBlock.Side.BOTH);
                level.m_46961_(abovePos, true);
                level.m_7731_(abovePos, placeState, 3);
            }
            level.m_5594_(null, pos.m_7494_(), SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
            EscalatedTriggers.HANDRAIL.tryAwardingTo(player);
            return true;
        }
        Direction left = dir.m_122428_();
        for (int i = 0; i < MAX_ITER; ++i) {
            leftPos = centralPos.m_5484_(left, i);
            BlockState leftState = level.m_8055_((BlockPos)leftPos);
            Block block = leftState.m_60734_();
            if (!(block instanceof WalkwayBlock)) {
                return false;
            }
            WalkwayBlock leftWalkway = (WalkwayBlock)block;
            if (leftWalkway.connectedToWalkwayOnSide(level, leftState, (BlockPos)leftPos, left)) continue;
            referenceState = leftState;
            centralPos = leftPos;
            break;
        }
        if (!((leftPos = level.m_7702_(centralPos)) instanceof WalkwayBlockEntity)) {
            return false;
        }
        WalkwayBlockEntity centralBE = (WalkwayBlockEntity)leftPos;
        if (level.m_8055_(centralPos.m_7494_()).m_60734_() instanceof AbstractHandrailBlock) {
            return false;
        }
        ArrayList<BlockPos> leftPositions = new ArrayList<BlockPos>();
        BlockState iterState = referenceState;
        BlockPos iterPos = centralPos;
        leftPositions.add(iterPos);
        for (boolean forward : Iterate.trueAndFalse) {
            iterState = referenceState;
            iterPos = centralPos;
            for (int i = 0; i < MAX_ITER && (iterPos = WalkwayBlock.nextSegmentPosition(iterState, iterPos, forward, true)) != null; ++i) {
                iterState = level.m_8055_(iterPos);
                if (!(iterState.m_60734_() instanceof WalkwayBlock) || !level.m_8055_(iterPos.m_7494_()).m_247087_()) {
                    return false;
                }
                leftPositions.add(iterPos);
            }
        }
        WalkwayBlockEntity walkwayBlockEntity = centralBE.getControllerBE();
        if (walkwayBlockEntity == null) {
            return false;
        }
        int width = walkwayBlockEntity.walkwayWidth;
        int offset = width - 1;
        referenceState = level.m_8055_(centralPos = centralPos.m_5484_(left, -offset));
        if (!(referenceState.m_60734_() instanceof WalkwayBlock)) {
            return false;
        }
        for (BlockPos leftBasePos : leftPositions) {
            BlockPos rightAbovePos = leftBasePos.m_5484_(left, -offset).m_7494_();
            if (level.m_8055_(leftBasePos.m_7494_()).m_247087_() && level.m_8055_(rightAbovePos).m_247087_()) continue;
            return false;
        }
        for (BlockPos leftBasePos : leftPositions) {
            BlockState leftBaseState = level.m_8055_(leftBasePos);
            WalkwayBlock otherWalkway = (WalkwayBlock)leftBaseState.m_60734_();
            BlockPos leftAbovePos = leftBasePos.m_7494_();
            BlockState leftPlaceState = handrail.getStateForSlope(level, leftBasePos, leftBaseState, leftAbovePos, dir, otherWalkway.getWalkwaySlope(leftBaseState), AbstractHandrailBlock.Side.LEFT);
            level.m_46961_(leftAbovePos, true);
            level.m_7731_(leftAbovePos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)leftPlaceState, (BlockPos)leftAbovePos), 3);
            BlockEntity blockEntity = level.m_7702_(leftAbovePos);
            if (blockEntity instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)blockEntity;
                handrailBE.width = width;
            }
            BlockPos rightBasePos = leftBasePos.m_5484_(left, -offset);
            BlockState rightBaseState = level.m_8055_(rightBasePos);
            BlockPos rightAbovePos = rightBasePos.m_7494_();
            BlockState rightPlaceState = handrail.getStateForSlope(level, rightBasePos, rightBaseState, rightAbovePos, dir, otherWalkway.getWalkwaySlope(rightBaseState), AbstractHandrailBlock.Side.RIGHT);
            level.m_46961_(rightAbovePos, true);
            level.m_7731_(rightAbovePos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)rightPlaceState, (BlockPos)rightAbovePos), 3);
            BlockEntity blockEntity2 = level.m_7702_(rightAbovePos);
            if (!(blockEntity2 instanceof HandrailBlockEntity)) continue;
            HandrailBlockEntity handrailBE = (HandrailBlockEntity)blockEntity2;
            handrailBE.width = width;
        }
        level.m_5594_(null, pos.m_7494_(), SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
        EscalatedTriggers.HANDRAIL.tryAwardingTo(player);
        return true;
    }

    @Override
    public WalkwaySet getWalkwaySet() {
        if (this.walkwaySet == null) {
            this.walkwaySet = (WalkwaySet)this.walkwaySetSupplier.get();
        }
        return this.walkwaySet;
    }
}

