/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei.melting;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.common.compat.jei.melting.FiredCrucibleTooltipCallback;
import novamachina.exnihilosequentia.common.compat.jei.melting.JEICrucibleRecipe;
import novamachina.exnihilosequentia.common.compat.jei.melting.WoodCrucibleTooltipCallback;

public class MeltingRecipeCategory
implements IRecipeCategory<JEICrucibleRecipe> {
    @Nonnull
    public static final ResourceLocation UID = new ResourceLocation("exnihilosequentia", "melting");
    @Nonnull
    private static final ResourceLocation texture = new ResourceLocation("exnihilosequentia", "textures/gui/jei_mid.png");
    @Nonnull
    private final IDrawableStatic background;
    @Nonnull
    private final IDrawableStatic slotHighlight;
    @Nonnull
    private final ResourceLocation uid;

    public MeltingRecipeCategory(@Nonnull IGuiHelper guiHelper, @Nonnull String uid) {
        this.background = guiHelper.createDrawable(texture, 0, 168, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
        this.uid = new ResourceLocation("exnihilosequentia", uid);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public RecipeType<JEICrucibleRecipe> getRecipeType() {
        return new RecipeType(this.uid, JEICrucibleRecipe.class);
    }

    @Nonnull
    public Component getTitle() {
        if (this.uid.equals((Object)new ResourceLocation("exnihilosequentia", "crucible_fired"))) {
            return Component.m_237115_((String)"jei.category.fired_melting");
        }
        return Component.m_237115_((String)"jei.category.melting");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JEICrucibleRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 3, 21);
        FluidStack resultFluid = recipe.getResultFluid().copy();
        if (resultFluid.getAmount() != 1000) {
            resultFluid.setAmount(1000);
        }
        output.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)resultFluid);
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            int slotX = 39 + i % 7 * 18;
            int slotY = 3 + i / 7 * 18;
            ItemStack stack = recipe.getInputs().get(i);
            IRecipeSlotBuilder input = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addItemStack(stack);
            if (this.uid.equals((Object)new ResourceLocation("exnihilosequentia", "fired_crucible"))) {
                input.addTooltipCallback((IRecipeSlotTooltipCallback)new FiredCrucibleTooltipCallback());
                continue;
            }
            input.addTooltipCallback((IRecipeSlotTooltipCallback)new WoodCrucibleTooltipCallback());
        }
    }
}

