/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.novacore.data.recipes.RecipeBuilder;

public class HeatRecipeBuilder
extends RecipeBuilder<HeatRecipeBuilder> {
    private final int amount;
    private final Block inputBlock;
    private final StatePropertiesPredicate properties;

    protected HeatRecipeBuilder(Block inputBlock, int amount, StatePropertiesPredicate properties) {
        super(EXNRecipeSerializers.HEAT_RECIPE_SERIALIZER.recipeSerializer());
        this.inputBlock = inputBlock;
        this.amount = amount;
        this.properties = properties;
    }

    public static HeatRecipeBuilder heat(Block inputBlock, int amount) {
        return HeatRecipeBuilder.heat(inputBlock, amount, StatePropertiesPredicate.f_67658_);
    }

    public static HeatRecipeBuilder heat(Block inputBlock, int amount, StatePropertiesPredicate properties) {
        return new HeatRecipeBuilder(inputBlock, amount, properties);
    }

    protected void validate(ResourceLocation id) {
        Preconditions.checkArgument((this.inputBlock != null ? 1 : 0) != 0, (Object)"Input cannot be null.");
        Preconditions.checkArgument((this.amount > 0 ? 1 : 0) != 0, (Object)"Heat amount must be greater than 0.");
        Preconditions.checkNotNull((Object)this.properties, (Object)"Properties cannot be null.");
    }

    protected HeatRecipeResult getResult(ResourceLocation id) {
        return new HeatRecipeResult(id);
    }

    public class HeatRecipeResult
    extends RecipeBuilder.RecipeResult {
        public HeatRecipeResult(ResourceLocation id) {
            super((RecipeBuilder)HeatRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((Object)HeatRecipeBuilder.this.inputBlock).toString());
            json.addProperty("amount", (Number)HeatRecipeBuilder.this.amount);
            if (HeatRecipeBuilder.this.properties != StatePropertiesPredicate.f_67658_) {
                json.add("state", HeatRecipeBuilder.this.properties.m_67666_());
            }
        }
    }
}

