/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.level.block.entity.CrucibleBlockEntity;
import novamachina.novacore.data.recipes.RecipeBuilder;
import novamachina.novacore.util.FluidStackUtils;

public class MeltingRecipeBuilder
extends RecipeBuilder<MeltingRecipeBuilder> {
    private final Ingredient input;
    private final FluidStack result;
    private final CrucibleBlockEntity.CrucibleType type;

    protected MeltingRecipeBuilder(Ingredient input, FluidStack result, CrucibleBlockEntity.CrucibleType type) {
        super(EXNRecipeSerializers.MELTING_RECIPE_SERIALIZER.recipeSerializer());
        this.input = input;
        this.result = result;
        this.type = type;
    }

    public static MeltingRecipeBuilder melting(ItemLike input, FluidStack result, CrucibleBlockEntity.CrucibleType type) {
        return MeltingRecipeBuilder.melting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), result, type);
    }

    public static MeltingRecipeBuilder melting(TagKey<Item> input, FluidStack result, CrucibleBlockEntity.CrucibleType type) {
        return MeltingRecipeBuilder.melting(Ingredient.m_204132_(input), result, type);
    }

    public static MeltingRecipeBuilder melting(Ingredient input, FluidStack result, CrucibleBlockEntity.CrucibleType type) {
        return new MeltingRecipeBuilder(input, result, type);
    }

    protected void validate(ResourceLocation id) {
        Preconditions.checkNotNull((Object)this.input, (Object)"Input cannot be null.");
        Preconditions.checkNotNull((Object)this.result, (Object)"Fluid cannot be null");
        Preconditions.checkArgument((!this.result.isEmpty() ? 1 : 0) != 0, (Object)"Fluid amount cannot be 0");
        Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Crucible type cannot be null");
    }

    protected MeltingRecipeResult getResult(ResourceLocation id) {
        return new MeltingRecipeResult(id);
    }

    public class MeltingRecipeResult
    extends RecipeBuilder.RecipeResult {
        public MeltingRecipeResult(ResourceLocation id) {
            super((RecipeBuilder)MeltingRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.add("input", MeltingRecipeBuilder.this.input.m_43942_());
            json.add("fluidResult", FluidStackUtils.serialize((FluidStack)MeltingRecipeBuilder.this.result));
            json.addProperty("crucibleType", MeltingRecipeBuilder.this.type.getName());
        }
    }
}

