/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.common.base.Objects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ItemStackWithChance {
    private static final String BASE_KEY = "item";
    private static final String CHANCE_KEY = "chance";
    private static final String COUNT_KEY = "count";
    private final float chance;
    private final ItemStack itemStack;

    private ItemStackWithChance(ItemStack itemStack, float chance) {
        this.itemStack = itemStack;
        this.chance = chance;
    }

    public static ItemStackWithChance of(ItemStack itemStack) {
        return ItemStackWithChance.of(itemStack, 1.0f);
    }

    public static ItemStackWithChance of(ItemStack itemStack, int count) {
        itemStack.m_41764_(count);
        return ItemStackWithChance.of(itemStack, 1.0f);
    }

    public static ItemStackWithChance of(ItemStack itemStack, int count, float chance) {
        itemStack.m_41764_(count);
        return ItemStackWithChance.of(itemStack, chance);
    }

    public static ItemStackWithChance of(ItemStack itemStack, float chance) {
        return new ItemStackWithChance(itemStack, chance);
    }

    public static @NonNull ItemStackWithChance deserialize(JsonElement json) {
        if (json.isJsonObject() && json.getAsJsonObject().has(BASE_KEY)) {
            float chance = GsonHelper.m_13820_((JsonObject)json.getAsJsonObject(), (String)CHANCE_KEY, (float)1.0f);
            String itemString = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)BASE_KEY);
            int count = 1;
            if (json.getAsJsonObject().has(COUNT_KEY)) {
                count = json.getAsJsonObject().get(COUNT_KEY).getAsInt();
            }
            return ItemStackWithChance.of(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString)), count), chance);
        }
        String itemString = GsonHelper.m_13805_((JsonElement)json, (String)BASE_KEY);
        return ItemStackWithChance.of(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString))), 1.0f);
    }

    public static @NonNull ItemStackWithChance read(FriendlyByteBuf buffer) {
        ItemStack stack = buffer.m_130267_();
        float chance = buffer.readFloat();
        return new ItemStackWithChance(stack, chance);
    }

    public @NonNull ItemStack getStack() {
        return this.itemStack.m_41777_();
    }

    public @NonNull JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty(CHANCE_KEY, (Number)Float.valueOf(this.getChance()));
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)this.getStack().m_41720_());
        if (resourceLocation != null) {
            json.addProperty(BASE_KEY, resourceLocation.toString());
        }
        json.addProperty(COUNT_KEY, (Number)this.getStack().m_41613_());
        return json;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.getStack());
        buffer.writeFloat(this.getChance());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackWithChance that = (ItemStackWithChance)o;
        return Float.compare(this.getChance(), that.getChance()) == 0 && ItemStack.m_41728_((ItemStack)this.itemStack, (ItemStack)that.itemStack);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.getChance()), this.itemStack});
    }

    public float getChance() {
        return this.chance;
    }
}

