/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature;

import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.Feature;
import me.paulf.fairylights.util.FLMth;
import me.paulf.fairylights.util.matrix.MatrixStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class HangingFeature
implements Feature {
    protected final int index;
    protected Vec3 point;
    protected Vec3 prevPoint;
    private Vec3 targetPoint;
    protected float yaw;
    protected float pitch;
    protected float roll;
    protected float prevYaw;
    protected float prevPitch;
    protected float prevRoll;
    protected float targetYaw;
    protected float targetPitch;
    protected final float descent;

    public HangingFeature(int index, Vec3 point, float yaw, float pitch, float roll, float descent) {
        this.index = index;
        this.prevPoint = this.targetPoint = point;
        this.point = this.targetPoint;
        this.yaw = this.targetYaw = yaw;
        this.prevYaw = this.targetYaw;
        this.pitch = this.targetPitch = pitch;
        this.prevPitch = this.targetPitch;
        this.prevRoll = this.roll = roll;
        this.descent = descent;
    }

    public void set(Vec3 point, float yaw, float pitch) {
        this.targetPoint = point;
        this.targetYaw = yaw;
        this.targetPitch = pitch;
    }

    @Override
    public final int getId() {
        return this.index;
    }

    public final Vec3 getPoint() {
        return this.targetPoint;
    }

    public final Vec3 getPoint(float delta) {
        return this.point.m_82546_(this.prevPoint).m_82490_((double)delta).m_82549_(this.prevPoint);
    }

    public final float getYaw() {
        return this.yaw;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final float getRoll() {
        return this.roll;
    }

    public final float getYaw(float t) {
        return FLMth.lerpAngle(this.prevYaw, this.yaw, t);
    }

    public final float getPitch(float t) {
        return FLMth.lerpAngle(this.prevPitch, this.pitch, t);
    }

    public final float getRoll(float t) {
        return FLMth.lerpAngle(this.prevRoll, this.roll, t);
    }

    public float getDescent() {
        return this.descent;
    }

    public final Vec3 getAbsolutePoint(Fastener<?> fastener) {
        return this.getAbsolutePoint(fastener.getConnectionPoint());
    }

    public final Vec3 getAbsolutePoint(Vec3 origin) {
        return this.point.m_82549_(origin);
    }

    public Vec3 getTransformedPoint(Vec3 origin, Vec3 point) {
        MatrixStack matrix = new MatrixStack();
        matrix.rotate(-this.getYaw(), 0.0f, 1.0f, 0.0f);
        if (this.parallelsCord()) {
            matrix.rotate(this.getPitch(), 0.0f, 0.0f, 1.0f);
        }
        matrix.rotate(this.getRoll(), 1.0f, 0.0f, 0.0f);
        matrix.translate(0.0f, -this.getDescent(), 0.0f);
        return this.point.m_82549_(matrix.transform(point)).m_82549_(origin);
    }

    public void tick(Level world) {
        this.prevPoint = this.point;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.prevRoll = this.roll;
        this.point = this.targetPoint;
        this.yaw = this.targetYaw;
        this.pitch = this.targetPitch;
    }

    public abstract AABB getBounds();

    public abstract boolean parallelsCord();
}

