/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;

public class SpiderDonutBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty DONUTS = IntegerProperty.m_61631_((String)"donuts", (int)0, (int)4);
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;

    public SpiderDonutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    public IntegerProperty getServingsProperty() {
        return DONUTS;
    }

    public int getMaxServings() {
        return 4;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)HANGING)).booleanValue()) {
            return switch ((Integer)state.m_61143_((Property)DONUTS)) {
                case 0 -> Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
                case 1 -> Block.m_49796_((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
                case 2 -> Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
                default -> Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);
            };
        }
        return switch ((Integer)state.m_61143_((Property)DONUTS)) {
            case 0 -> Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
            case 1 -> Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
            case 2 -> Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
            default -> Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return level.f_46443_ && this.takeServing((LevelAccessor)level, pos, state, player, hand).m_19077_() ? InteractionResult.SUCCESS : this.takeServing((LevelAccessor)level, pos, state, player, hand);
    }

    protected InteractionResult takeServing(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)this.getServingsProperty());
        ItemStack heldStack = player.m_21120_(hand);
        if (!heldStack.m_150930_(this.m_5456_()) && player.m_36391_(false)) {
            player.m_36324_().m_38707_(3, 0.3f);
            player.m_7292_(new MobEffectInstance((MobEffect)DDEffects.POUNCING.get(), 900, 1));
            level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
            if (servings == 0) {
                level.m_7471_(pos, false);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)DONUTS, (Comparable)Integer.valueOf(servings - 1)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)DONUTS) < this.getMaxServings() || super.m_6864_(state, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)DONUTS, (Comparable)Integer.valueOf(Math.min((Integer)blockstate.m_61143_((Property)DONUTS) + 1, this.getMaxServings())));
        }
        for (Direction direction : context.m_6232_()) {
            if (direction.m_122434_() != Direction.Axis.Y) continue;
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP));
        }
        return null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)HANGING)).booleanValue()) {
            return facing == Direction.UP && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
        }
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)HANGING)).booleanValue()) {
            return level.m_8055_(pos.m_7494_()).m_280296_();
        }
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, DONUTS, HANGING});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)this.getServingsProperty());
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

