/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client;

import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.client.screen.main.MonitorScreen;
import whocraft.tardis_refined.client.screen.ponder.PonderListScreen;
import whocraft.tardis_refined.client.screen.screens.CancelDesktopScreen;
import whocraft.tardis_refined.client.screen.screens.ShellSelectionScreen;
import whocraft.tardis_refined.client.screen.screens.WaypointListScreen;
import whocraft.tardis_refined.client.screen.screens.WaypointManageScreen;
import whocraft.tardis_refined.client.screen.upgrades.UpgradesScreen;
import whocraft.tardis_refined.client.screen.waypoints.CoordInputType;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.TardisWaypoint;

@OnlyIn(value=Dist.CLIENT)
public class ScreenHandler {
    @OnlyIn(value=Dist.CLIENT)
    public static void setWaypointScreen(Collection<TardisWaypoint> waypoints) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof MonitorOS) {
            ((MonitorOS)mc.f_91080_).switchScreenToRight(new WaypointListScreen(waypoints));
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new WaypointListScreen(waypoints));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setCoordinatesScreen(List<ResourceKey<Level>> levels, CoordInputType coordInputType, TardisNavLocation tardisNavLocation) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof MonitorOS) {
            ((MonitorOS)mc.f_91080_).switchScreenToRight(new WaypointManageScreen(levels, coordInputType, tardisNavLocation));
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new WaypointManageScreen(levels, coordInputType, tardisNavLocation));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setEditCoordinatesScreen(TardisWaypoint waypoint) {
        Minecraft.m_91087_().m_91152_((Screen)new WaypointManageScreen(waypoint));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openMonitorScreen(boolean desktopGenerating, CompoundTag upgradeHandlerNbt, TardisNavLocation currentLocation, TardisNavLocation targetLocation, ResourceLocation currentShellTheme) {
        if (desktopGenerating) {
            Minecraft.m_91087_().m_91152_((Screen)new CancelDesktopScreen());
        } else {
            assert (Minecraft.m_91087_().f_91073_ != null);
            UpgradeHandler upgradeHandlerClient = new UpgradeHandler(new TardisLevelOperator((Level)Minecraft.m_91087_().f_91073_));
            upgradeHandlerClient.loadData(upgradeHandlerNbt);
            Minecraft.m_91087_().m_91152_((Screen)new MonitorScreen(currentLocation, targetLocation, upgradeHandlerClient, currentShellTheme));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openCoordinatesScreen(List<ResourceKey<Level>> levels, CoordInputType coordInputType, TardisNavLocation tardisNavLocation) {
        ScreenHandler.setCoordinatesScreen(levels, coordInputType, tardisNavLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openEditCoordinatesScreen(TardisWaypoint waypoint) {
        ScreenHandler.setEditCoordinatesScreen(waypoint);
    }

    /*
     * Enabled aggressive block sorting
     */
    @OnlyIn(value=Dist.CLIENT)
    public static void displayUpgradesScreen(CompoundTag upgradeTag) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        UpgradeHandler upgradeHandlerClient = new UpgradeHandler(new TardisLevelOperator((Level)Minecraft.m_91087_().f_91073_));
        upgradeHandlerClient.loadData(upgradeTag);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof UpgradesScreen) {
            UpgradesScreen screen2 = (UpgradesScreen)screen;
            if (screen2.selectedTab != null) {
                screen2.selectedTab.populate(upgradeHandlerClient);
                return;
            }
        }
        Minecraft.m_91087_().m_91152_((Screen)new UpgradesScreen(upgradeHandlerClient));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openShellSelection(ResourceLocation currentShell) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof MonitorOS) {
            ((MonitorOS)mc.f_91080_).switchScreenToRight(new ShellSelectionScreen(currentShell));
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new ShellSelectionScreen(currentShell));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openCraftingScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new PonderListScreen());
    }
}

