/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.components;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class SpriteIconButton
extends Button {
    protected final ResourceLocation sprite;
    protected final int spriteWidth;
    protected final int spriteHeight;

    SpriteIconButton(int i, int j, Component component, int k, int l, ResourceLocation resourceLocation, Button.OnPress onPress) {
        super(0, 0, i, j, component, onPress, f_252438_);
        this.spriteWidth = k;
        this.spriteHeight = l;
        this.sprite = resourceLocation;
    }

    public static Builder builder(Component component, Button.OnPress onPress, boolean bl) {
        return new Builder(component, onPress, bl);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Component message;
        private final Button.OnPress onPress;
        private final boolean iconOnly;
        private int width = 150;
        private int height = 20;
        @Nullable
        private ResourceLocation sprite;
        private int spriteWidth;
        private int spriteHeight;

        public Builder(Component component, Button.OnPress onPress, boolean bl) {
            this.message = component;
            this.onPress = onPress;
            this.iconOnly = bl;
        }

        public Builder width(int i) {
            this.width = i;
            return this;
        }

        public Builder size(int i, int j) {
            this.width = i;
            this.height = j;
            return this;
        }

        public Builder sprite(ResourceLocation resourceLocation, int i, int j) {
            this.sprite = resourceLocation;
            this.spriteWidth = i;
            this.spriteHeight = j;
            return this;
        }

        public SpriteIconButton build() {
            if (this.sprite == null) {
                throw new IllegalStateException("Sprite not set");
            }
            if (this.iconOnly) {
                return new CenteredIcon(this.width, this.height, this.message, this.spriteWidth, this.spriteHeight, this.sprite, this.onPress);
            }
            return new TextAndIcon(this.width, this.height, this.message, this.spriteWidth, this.spriteHeight, this.sprite, this.onPress);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CenteredIcon
    extends SpriteIconButton {
        protected CenteredIcon(int i, int j, Component component, int k, int l, ResourceLocation resourceLocation, Button.OnPress onPress) {
            super(i, j, component, k, l, resourceLocation, onPress);
        }

        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_87963_(guiGraphics, i, j, f);
            int k = this.m_252754_() + this.m_5711_() / 2 - this.spriteWidth / 2;
            int l = this.m_252907_() + this.m_93694_() / 2 - this.spriteHeight / 2;
            guiGraphics.m_280163_(this.sprite, 0, 0, (float)this.spriteWidth, (float)this.spriteHeight, k, l, 10, 10);
        }

        public void m_280139_(GuiGraphics guiGraphics, Font font, int i) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TextAndIcon
    extends SpriteIconButton {
        protected TextAndIcon(int i, int j, Component component, int k, int l, ResourceLocation resourceLocation, Button.OnPress onPress) {
            super(i, j, component, k, l, resourceLocation, onPress);
        }

        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_87963_(guiGraphics, i, j, f);
            int k = this.m_252754_() + this.m_5711_() - this.spriteWidth - 2;
            int l = this.m_252907_() + this.m_93694_() / 2 - this.spriteHeight / 2;
            guiGraphics.m_280163_(this.sprite, 0, 0, (float)this.spriteWidth, (float)this.spriteHeight, k, l, 10, 10);
        }

        public void m_280139_(GuiGraphics guiGraphics, Font font, int i) {
            int j = this.m_252754_() + 2;
            int k = this.m_252754_() + this.m_5711_() - this.spriteWidth - 4;
            int l = this.m_252754_() + this.m_5711_() / 2;
            TextAndIcon.m_280138_((GuiGraphics)guiGraphics, (Font)font, (Component)this.m_6035_(), (int)l, (int)j, (int)this.m_252907_(), (int)k, (int)(this.m_252907_() + this.m_93694_()));
        }
    }
}

