/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.blockentity.device.AstralManipulatorBlockEntity;
import whocraft.tardis_refined.common.items.ScrewdriverMode;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class ScrewdriverItem
extends Item
implements DyeableLeatherItem {
    public static final String SCREWDRIVER_MODE = "screwdriver_mode";
    public static final String LINKED_MANIPULATOR_POS = "linked_manipulator_pos";
    public static final String SCREWDRIVER_POINT_A = "screwdriver_point_a";
    public static final String SCREWDRIVER_POINT_B = "screwdriver_point_b";
    public static final String SCREWDRIVER_B_WAS_LAST_UPDATED = "screwdriver_b_was_last_updated_pos";

    public ScrewdriverItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack forceColor(ItemStack itemStack, int color) {
        itemStack.m_41698_("display").m_128405_("color", color);
        return itemStack;
    }

    public int m_41121_(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41737_("display");
        return compoundTag != null && compoundTag.m_128425_("color", 99) ? compoundTag.m_128451_("color") : DyeColor.PINK.m_41071_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return super.m_6225_(context);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Player player = context.m_43723_();
        ItemStack itemInHand = context.m_43722_();
        BlockPos clickedPos = context.m_8083_();
        BlockState blockState = context.m_43725_().m_8055_(clickedPos);
        if (player.m_6047_()) {
            ScrewdriverMode newMode = this.isScrewdriverMode(itemInHand, ScrewdriverMode.ENABLED) ? ScrewdriverMode.DISABLED : ScrewdriverMode.ENABLED;
            this.setScrewdriverMode(context.m_43723_(), itemInHand, newMode, clickedPos, serverLevel);
        } else if (this.isScrewdriverMode(itemInHand, ScrewdriverMode.DRAWING) && blockState.m_60734_() != TRBlockRegistry.ASTRAL_MANIPULATOR_BLOCK.get()) {
            this.addBlockPosToScrewdriver(serverLevel, player, itemInHand, clickedPos);
        }
        return super.m_6225_(context);
    }

    public void setScrewdriverMode(Player player, ItemStack stack, ScrewdriverMode mode, BlockPos sourceChange, @Nullable ServerLevel serverLevel) {
        Block sourceBlock;
        ScrewdriverMode currentMode;
        CompoundTag itemTag = stack.m_41784_();
        ScrewdriverMode screwdriverMode = currentMode = itemTag.m_128441_(SCREWDRIVER_MODE) ? ScrewdriverMode.valueOf(itemTag.m_128461_(SCREWDRIVER_MODE)) : ScrewdriverMode.DISABLED;
        if (serverLevel != null) {
            if (currentMode != ScrewdriverMode.DISABLED && mode == ScrewdriverMode.DISABLED) {
                this.playScrewdriverSound(serverLevel, sourceChange, TRSoundRegistry.SCREWDRIVER_DISCARD.get());
            }
            if (currentMode == ScrewdriverMode.DRAWING && mode != ScrewdriverMode.DRAWING) {
                this.clearLinkedManipulator(serverLevel, stack);
            }
        }
        itemTag.m_128359_(SCREWDRIVER_MODE, mode.toString());
        if (mode == ScrewdriverMode.DRAWING) {
            itemTag.m_128365_(LINKED_MANIPULATOR_POS, (Tag)NbtUtils.m_129224_((BlockPos)sourceChange));
        }
        if ((sourceBlock = player.m_9236_().m_8055_(sourceChange).m_60734_()) != null && sourceBlock != TRBlockRegistry.ASTRAL_MANIPULATOR_BLOCK.get()) {
            PlayerUtil.sendMessage((LivingEntity)player, mode.toString(), true);
        }
        stack.m_41751_(itemTag);
    }

    public boolean isScrewdriverMode(ItemStack stack, ScrewdriverMode mode) {
        CompoundTag itemtag = stack.m_41784_();
        if (itemtag.m_128441_(SCREWDRIVER_MODE)) {
            ScrewdriverMode currentMode = ScrewdriverMode.valueOf(itemtag.m_128461_(SCREWDRIVER_MODE));
            return mode == currentMode;
        }
        return false;
    }

    private void addBlockPosToScrewdriver(ServerLevel serverLevel, Player player, ItemStack stack, BlockPos pos) {
        CompoundTag itemtag = stack.m_41784_();
        boolean isUpdatingA = true;
        String target = SCREWDRIVER_POINT_A;
        if (itemtag.m_128441_(SCREWDRIVER_B_WAS_LAST_UPDATED) && !(isUpdatingA = itemtag.m_128471_(SCREWDRIVER_B_WAS_LAST_UPDATED))) {
            target = SCREWDRIVER_POINT_B;
        }
        itemtag.m_128365_(target, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        this.updatedLinkedManipulator(player, (ServerLevel)player.m_9236_(), stack, pos, isUpdatingA);
        itemtag.m_128379_(SCREWDRIVER_B_WAS_LAST_UPDATED, !isUpdatingA);
        stack.m_41751_(itemtag);
        this.playScrewdriverSound(serverLevel, player.m_20097_(), TRSoundRegistry.SCREWDRIVER_SHORT.get());
    }

    public void playScrewdriverSound(ServerLevel level, BlockPos pos, SoundEvent soundEvent) {
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundEvent, SoundSource.PLAYERS, 1.0f, 0.875f + level.m_213780_().m_188501_() / 4.0f);
    }

    private void updatedLinkedManipulator(Player player, ServerLevel level, ItemStack stack, BlockPos pos, boolean isPointA) {
        AstralManipulatorBlockEntity astralManipulatorBlockEntity;
        BlockPos manipulator;
        BlockEntity blockEntity;
        CompoundTag itemtag = stack.m_41784_();
        if (itemtag.m_128441_(LINKED_MANIPULATOR_POS) && (blockEntity = level.m_7702_(manipulator = NbtUtils.m_129239_((CompoundTag)itemtag.m_128469_(LINKED_MANIPULATOR_POS)))) instanceof AstralManipulatorBlockEntity && !(astralManipulatorBlockEntity = (AstralManipulatorBlockEntity)blockEntity).setProjectionBlockPos(pos, isPointA)) {
            this.setScrewdriverMode(player, stack, ScrewdriverMode.DISABLED, pos, level);
        }
    }

    private void clearLinkedManipulator(ServerLevel level, ItemStack stack) {
        CompoundTag itemtag = stack.m_41784_();
        if (itemtag.m_128441_(LINKED_MANIPULATOR_POS)) {
            BlockPos manipulator = NbtUtils.m_129239_((CompoundTag)itemtag.m_128469_(LINKED_MANIPULATOR_POS));
            BlockEntity blockEntity = level.m_7702_(manipulator);
            if (blockEntity instanceof AstralManipulatorBlockEntity) {
                AstralManipulatorBlockEntity astralManipulatorBlockEntity = (AstralManipulatorBlockEntity)blockEntity;
                astralManipulatorBlockEntity.clearDisplay();
            }
            itemtag.m_128473_(LINKED_MANIPULATOR_POS);
        }
    }

    public void clearBlockPosFromScrewdriver(ItemStack stack) {
        CompoundTag itemtag = stack.m_41784_();
        if (itemtag.m_128441_(SCREWDRIVER_POINT_A)) {
            itemtag.m_128473_(SCREWDRIVER_POINT_A);
        }
        if (itemtag.m_128441_(SCREWDRIVER_POINT_B)) {
            itemtag.m_128473_(SCREWDRIVER_POINT_B);
        }
        if (itemtag.m_128441_(LINKED_MANIPULATOR_POS)) {
            itemtag.m_128473_(LINKED_MANIPULATOR_POS);
        }
        stack.m_41751_(itemtag);
    }

    public List<BlockPos> getScrewdriverPoint(ItemStack stack) {
        CompoundTag itemtag = stack.m_41784_();
        ArrayList<BlockPos> listOfBlockPos = new ArrayList<BlockPos>();
        if (itemtag.m_128441_(SCREWDRIVER_POINT_A)) {
            listOfBlockPos.add(NbtUtils.m_129239_((CompoundTag)itemtag.m_128469_(SCREWDRIVER_POINT_A)));
        }
        if (itemtag.m_128441_(SCREWDRIVER_POINT_B)) {
            listOfBlockPos.add(NbtUtils.m_129239_((CompoundTag)itemtag.m_128469_(SCREWDRIVER_POINT_B)));
        }
        return listOfBlockPos;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add((Component)Component.m_237115_((String)ModMessages.TOOLTIP_SCREWDRIVER_DESCRIPTION));
    }
}

