/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.forge;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.NetworkManager;

public class NetworkManagerImpl
extends NetworkManager {
    private final SimpleChannel channel;

    public NetworkManagerImpl(ResourceLocation channelName) {
        super(channelName);
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)channelName, () -> "1.0.0", s -> true, s -> true);
        this.channel.registerMessage(0, ToServer.class, ToServer::toBytes, x$0 -> new ToServer((FriendlyByteBuf)x$0), ToServer::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(1, ToClient.class, ToClient::toBytes, x$0 -> new ToClient((FriendlyByteBuf)x$0), ToClient::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static NetworkManager create(ResourceLocation channelName) {
        return new NetworkManagerImpl(channelName);
    }

    @Override
    public void sendToServer(MessageC2S message) {
        if (!toServer.containsValue(message.getType())) {
            TardisRefined.LOGGER.error("Message type not registered: " + message.getType().getId());
            return;
        }
        this.channel.sendToServer((Object)new ToServer(message));
    }

    @Override
    public void sendToPlayer(ServerPlayer player, MessageS2C message) {
        if (!this.toClient.containsValue(message.getType())) {
            TardisRefined.LOGGER.error("Message type not registered: " + message.getType().getId());
            return;
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ToClient(message));
    }

    @Override
    public void sendToTrackingAndSelf(ServerPlayer player, MessageS2C message) {
        if (!this.toClient.containsValue(message.getType())) {
            TardisRefined.LOGGER.error("Message type not registered: " + message.getType().getId());
            return;
        }
        this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)message);
    }

    @Override
    public void sendToTracking(Entity entity, MessageS2C message) {
        if (!this.toClient.containsValue(message.getType())) {
            TardisRefined.LOGGER.error("Message type not registered: " + message.getType().getId());
            return;
        }
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
    }

    @Override
    public void sendToTracking(BlockEntity blockEntity, MessageS2C message) {
        if (!this.toClient.containsValue(message.getType())) {
            TardisRefined.LOGGER.error("Message type not registered: " + message.getType().getId());
            return;
        }
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> blockEntity.m_58904_().m_46745_(blockEntity.m_58899_())), (Object)message);
    }

    public class ToServer {
        private final MessageC2S message;

        public ToServer(MessageC2S message) {
            this.message = message;
        }

        public ToServer(FriendlyByteBuf buf) {
            String msgId = buf.m_130277_();
            if (!toServer.containsKey(msgId)) {
                TardisRefined.LOGGER.warn("Unknown message id received on server: " + msgId);
                this.message = null;
                return;
            }
            MessageType type = (MessageType)toServer.get(msgId);
            this.message = (MessageC2S)type.getDecoder().decode(buf);
        }

        public static void handle(ToServer msg, Supplier<NetworkEvent.Context> ctx) {
            if (msg.message != null) {
                ctx.get().enqueueWork(() -> msg.message.handle(() -> ToServer.lambda$handle$0((Supplier)ctx)));
            }
            ctx.get().setPacketHandled(true);
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.m_130070_(this.message.getType().getId());
            this.message.toBytes(buf);
        }

        private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier ctx) {
            return ((NetworkEvent.Context)ctx.get()).getSender();
        }
    }

    public class ToClient {
        private final MessageS2C message;

        public ToClient(MessageS2C message) {
            this.message = message;
        }

        public ToClient(FriendlyByteBuf buf) {
            String msgId = buf.m_130277_();
            if (!NetworkManagerImpl.this.toClient.containsKey(msgId)) {
                TardisRefined.LOGGER.warn("Unknown message id received on client: " + msgId);
                this.message = null;
                return;
            }
            MessageType type = (MessageType)NetworkManagerImpl.this.toClient.get(msgId);
            this.message = (MessageS2C)type.getDecoder().decode(buf);
        }

        public static void handle(ToClient msg, Supplier<NetworkEvent.Context> ctx) {
            if (msg.message != null) {
                ctx.get().enqueueWork(() -> msg.message.handle(() -> null));
            }
            ctx.get().setPacketHandled(true);
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.m_130070_(this.message.getType().getId());
            this.message.toBytes(buf);
        }
    }
}

