/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.screens;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.ScreenHandler;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;

public class S2COpenMonitor
extends MessageS2C {
    private final boolean desktopGenerating;
    private final TardisNavLocation currentLocation;
    private final TardisNavLocation targetLocation;
    private final CompoundTag upgradeHandlerNbt;
    private final ResourceLocation currentShellTheme;

    public S2COpenMonitor(boolean desktopGenerating, TardisNavLocation currentLocation, TardisNavLocation targetLocation, UpgradeHandler upgradeHandler, ResourceLocation currentShellTheme) {
        this.desktopGenerating = desktopGenerating;
        this.currentLocation = currentLocation;
        this.targetLocation = targetLocation;
        this.upgradeHandlerNbt = upgradeHandler.saveData(new CompoundTag());
        this.currentShellTheme = currentShellTheme;
    }

    public S2COpenMonitor(FriendlyByteBuf friendlyByteBuf) {
        this.desktopGenerating = friendlyByteBuf.readBoolean();
        this.currentLocation = TardisNavLocation.deserialize(Objects.requireNonNull(friendlyByteBuf.m_130260_()));
        this.targetLocation = TardisNavLocation.deserialize(Objects.requireNonNull(friendlyByteBuf.m_130260_()));
        this.upgradeHandlerNbt = friendlyByteBuf.m_130260_();
        this.currentShellTheme = friendlyByteBuf.m_130281_();
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.OPEN_MONITOR;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.desktopGenerating);
        buf.m_130079_(this.currentLocation.serialise());
        buf.m_130079_(this.targetLocation.serialise());
        buf.m_130079_(this.upgradeHandlerNbt);
        buf.m_130085_(this.currentShellTheme);
    }

    @Override
    public void handle(MessageContext context) {
        this.handleScreens();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleScreens() {
        ScreenHandler.openMonitorScreen(this.desktopGenerating, this.upgradeHandlerNbt, this.currentLocation, this.targetLocation, this.currentShellTheme);
    }
}

