/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.soundscape.hum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.util.CodecJsonReloadListener;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class TardisHums {
    public static final HumEntry CAVE = new HumEntry("cave", TRSoundRegistry.HUM_CAVE.getId());
    public static final HumEntry TOYOTA = new HumEntry("toyota", TRSoundRegistry.HUM_TOYOTA.getId());
    public static final HumEntry CLASSIC = new HumEntry("classic", TRSoundRegistry.HUM_CLASSIC.getId());
    public static final HumEntry VICTORIAN = new HumEntry("victorian", TRSoundRegistry.HUM_VICTORIAN.getId());
    public static final HumEntry BASALT_DELTAS = new HumEntry("basalt_deltas", ((SoundEvent)SoundEvents.f_11795_.m_203334_()).m_11660_(), TardisHums.createSoundList((SoundEvent)SoundEvents.f_11742_.m_203334_(), (SoundEvent)SoundEvents.f_11848_.m_203334_()));
    public static final HumEntry CRIMSON_FOREST = new HumEntry("crimson_forest", ((SoundEvent)SoundEvents.f_11954_.m_203334_()).m_11660_(), TardisHums.createSoundList((SoundEvent)SoundEvents.f_11901_.m_203334_(), (SoundEvent)SoundEvents.f_12007_.m_203334_()));
    public static final HumEntry NETHER_WASTES = new HumEntry("nether_wastes", ((SoundEvent)SoundEvents.f_12113_.m_203334_()).m_11660_(), TardisHums.createSoundList((SoundEvent)SoundEvents.f_12060_.m_203334_(), (SoundEvent)SoundEvents.f_12166_.m_203334_()));
    public static final HumEntry UNDER_WATER = new HumEntry("under_water", SoundEvents.f_12643_.m_11660_(), TardisHums.createSoundList(SoundEvents.f_12648_, SoundEvents.f_12649_, SoundEvents.f_12650_));
    public static final HumEntry SOUL_SAND_VALLEY = new HumEntry("soul_sand_valley", ((SoundEvent)SoundEvents.f_12272_.m_203334_()).m_11660_(), TardisHums.createSoundList((SoundEvent)SoundEvents.f_12219_.m_203334_(), (SoundEvent)SoundEvents.f_12325_.m_203334_()));
    public static final HumEntry WARPED_FOREST = new HumEntry("warped_forest", ((SoundEvent)SoundEvents.f_12431_.m_203334_()).m_11660_(), TardisHums.createSoundList((SoundEvent)SoundEvents.f_12378_.m_203334_(), (SoundEvent)SoundEvents.f_12484_.m_203334_()));
    public static final HumEntry AVIATRAX = new HumEntry("aviatrax", TRSoundRegistry.HUM_AVIATRAX.getId(), new ArrayList<ResourceLocation>());
    public static final HumEntry COPPER = new HumEntry("copper", TRSoundRegistry.HUM_COPPER.getId(), new ArrayList<ResourceLocation>());
    private static final CodecJsonReloadListener<HumEntry> RELOAD_LISTENER = TardisHums.createReloadListener();
    private static final Map<ResourceLocation, HumEntry> DEFAULT_HUMS = new HashMap<ResourceLocation, HumEntry>();

    private static List<ResourceLocation> createSoundList(SoundEvent ... sounds) {
        ArrayList<ResourceLocation> soundList = new ArrayList<ResourceLocation>();
        for (SoundEvent sound : sounds) {
            soundList.add(sound.m_11660_());
        }
        return soundList;
    }

    private static CodecJsonReloadListener<HumEntry> createReloadListener() {
        return CodecJsonReloadListener.create("tardis_refined/hums", HumEntry.codec());
    }

    public static CodecJsonReloadListener<HumEntry> getReloadListener() {
        return RELOAD_LISTENER;
    }

    public static Map<ResourceLocation, HumEntry> getRegistry() {
        return RELOAD_LISTENER.getData();
    }

    public static HumEntry getHumById(ResourceLocation location) {
        return RELOAD_LISTENER.getData().getOrDefault(location, TardisHums.getDefaultHum());
    }

    public static Map<ResourceLocation, HumEntry> registerDefaultHums() {
        DEFAULT_HUMS.clear();
        TardisHums.addDefaultHum(TardisHums.getDefaultHum());
        TardisHums.addDefaultHum(CAVE);
        TardisHums.addDefaultHum(TOYOTA);
        TardisHums.addDefaultHum(VICTORIAN);
        TardisHums.addDefaultHum(CLASSIC);
        TardisHums.addDefaultHum(AVIATRAX);
        return DEFAULT_HUMS;
    }

    private static HumEntry addDefaultHum(HumEntry hum) {
        DEFAULT_HUMS.put(hum.getIdentifier(), hum);
        return hum;
    }

    public static HumEntry getDefaultHum() {
        ArrayList<ResourceLocation> arrayList = new ArrayList<ResourceLocation>();
        arrayList.add(new ResourceLocation("tardis_refined", "interior_creaks"));
        return new HumEntry(new ResourceLocation("tardis_refined", "coral"), TRSoundRegistry.HUM_CORAL.getId(), arrayList);
    }

    public static Map<ResourceLocation, HumEntry> getDefaultHums() {
        return DEFAULT_HUMS;
    }
}

