/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class PlayerUtil {
    public static void globalMessage(Component body, MinecraftServer server) {
        if (server == null) {
            return;
        }
        PlayerList playerList = server.m_6846_();
        for (ServerPlayer player : playerList.m_11314_()) {
            player.m_213846_(body);
        }
    }

    public static void sendMessage(LivingEntity livingEntity, String message, boolean hotBar) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)message), hotBar);
        }
    }

    public static void sendMessage(LivingEntity livingEntity, Component translation, boolean hotBar) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.m_9236_().f_46443_) {
            player.m_5661_(translation, hotBar);
        }
    }

    public static void applyPotionIfAbsent(LivingEntity player, MobEffect potion, int length, int amplifier, boolean ambient, boolean showParticles) {
        if (potion == null) {
            return;
        }
        if (player.m_21124_(potion) == null) {
            player.m_7292_(new MobEffectInstance(potion, length, amplifier, ambient, showParticles));
        }
    }

    public static AABB getReach(BlockPos pos, int range) {
        return new AABB(pos.m_6630_(range).m_122013_(range).m_122025_(range), pos.m_6625_(range).m_122020_(range).m_122030_(range));
    }

    public static boolean isInHand(InteractionHand hand, LivingEntity holder, Item item) {
        ItemStack heldItem = holder.m_21120_(hand);
        return heldItem.m_41720_() == item;
    }

    public static boolean isInMainHand(LivingEntity holder, Item item) {
        return PlayerUtil.isInHand(InteractionHand.MAIN_HAND, holder, item);
    }

    public static boolean isInOffHand(LivingEntity holder, Item item) {
        return PlayerUtil.isInHand(InteractionHand.OFF_HAND, holder, item);
    }

    public static boolean isInEitherHand(LivingEntity holder, Item item) {
        return PlayerUtil.isInMainHand(holder, item) || PlayerUtil.isInOffHand(holder, item);
    }

    public static boolean isInOneHand(LivingEntity holder, Item item) {
        boolean mainHand = PlayerUtil.isInMainHand(holder, item) && !PlayerUtil.isInOffHand(holder, item);
        boolean offHand = PlayerUtil.isInOffHand(holder, item) && !PlayerUtil.isInMainHand(holder, item);
        return mainHand || offHand;
    }
}

