/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRVillagerProfession;
import whocraft.tardis_refined.villager.VillagerDuck;

@Mixin(value={Villager.class})
public class VillagerMixin
implements VillagerDuck {
    @Unique
    private static final EntityDataAccessor<Integer> PILOT_TICKS = SynchedEntityData.m_135353_(Villager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @Inject(method={"defineSynchedData()V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void defineSynchedData(CallbackInfo ci) {
        Villager villager = (Villager)this;
        villager.m_20088_().m_135372_(PILOT_TICKS, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")}, cancellable=true)
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128405_("tardis_refined_pilot_ticks", this.tardisRefined$getPilotingTicks());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")}, cancellable=true)
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        this.tardisRefined$setPilotingTicks(compoundTag.m_128451_("tardis_refined_pilot_ticks"));
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        Villager villager = (Villager)this;
        if (villager.m_7141_().m_35571_() == TRVillagerProfession.PILOT.get()) {
            if (player.m_21120_(interactionHand).m_150930_(Items.f_42616_)) {
                this.tardisRefined$setPilotingTicks(this.tardisRefined$getPilotingTicks() + 6000);
                player.m_21120_(interactionHand).m_41774_(1);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
            if (this.tardisRefined$getPilotingTicks() > 0) {
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237110_((String)ModMessages.PILOT_TIME, (Object[])new Object[]{MiscHelper.convertTicksToRealTime(this.tardisRefined$getPilotingTicks())}), true);
            } else {
                villager.m_35518_();
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.DEMANDS_PAYMENT), true);
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(CallbackInfo ci) {
        Villager villager = (Villager)this;
        Level level = villager.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TardisLevelOperator.get(serverLevel).ifPresent(tardisLevelOperator -> {
                TardisPilotingManager pilotingManager = tardisLevelOperator.getPilotingManager();
                if (pilotingManager.isCrashing() && !villager.m_6274_().m_21954_(Activity.f_37984_)) {
                    villager.m_6274_().m_21889_(Activity.f_37984_);
                    return;
                }
                if (pilotingManager.isLanding() && !villager.m_6274_().m_21954_(Activity.f_37989_)) {
                    villager.m_6274_().m_21889_(Activity.f_37989_);
                    return;
                }
                if (pilotingManager.isInFlight() && !villager.m_6274_().m_21954_(Activity.f_37980_)) {
                    villager.m_6274_().m_21944_(Activity.f_37980_);
                    villager.m_6274_().m_21889_(Activity.f_37980_);
                    return;
                }
            });
        }
    }

    @Override
    public void tardisRefined$setPilotingTicks(int ticks) {
        Villager villager = (Villager)this;
        villager.m_20088_().m_135381_(PILOT_TICKS, (Object)ticks);
    }

    @Override
    public int tardisRefined$getPilotingTicks() {
        Villager villager = (Villager)this;
        return (Integer)villager.m_20088_().m_135370_(PILOT_TICKS);
    }
}

