/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;

public class PatternTexture {
    private static final Codec<PatternTexture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(PatternTexture::texture), (App)Codec.BOOL.fieldOf("emissive").forGetter(PatternTexture::emissive)).apply((Applicative)instance, PatternTexture::new));
    private final ResourceLocation textureLocation;
    private final ResourceLocation emissiveTexture;
    private boolean hasEmissiveTexture = false;

    public PatternTexture(String textureLocation, boolean hasEmissiveTexture) {
        this(new ResourceLocation("tardis_refined", textureLocation), hasEmissiveTexture);
    }

    public PatternTexture(String textureLocation) {
        this(new ResourceLocation("tardis_refined", textureLocation));
    }

    public PatternTexture(ResourceLocation textureLocation) {
        this(textureLocation, false);
    }

    public PatternTexture(ResourceLocation textureLocation, boolean hasEmissiveTexture) {
        this.textureLocation = textureLocation;
        this.hasEmissiveTexture = hasEmissiveTexture;
        this.emissiveTexture = new ResourceLocation(textureLocation.m_135827_(), textureLocation.m_135815_().replace(".png", "_emissive.png"));
    }

    public static Codec<PatternTexture> getCodec() {
        return CODEC;
    }

    public boolean emissive() {
        return this.hasEmissiveTexture;
    }

    public PatternTexture setEmissive(boolean hasEmissiveTexture) {
        this.hasEmissiveTexture = hasEmissiveTexture;
        return this;
    }

    public ResourceLocation emissiveTexture() {
        return this.emissiveTexture;
    }

    public ResourceLocation texture() {
        return this.textureLocation;
    }
}

