/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class GrillRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack firstOutput;
    private final ResourceLocation id;

    public GrillRecipe(NonNullList<Ingredient> ingredients, ItemStack firstOutput, ResourceLocation id) {
        this.ingredients = ingredients;
        this.firstOutput = firstOutput;
        this.id = id;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(pContainer.m_8020_(0));
    }

    public NonNullList<Ingredient> m_7527_() {
        if (this.ingredients.isEmpty()) {
            System.err.println("JEI ERROR: Ingredients list not found!");
        }
        return this.ingredients;
    }

    public ItemStack getFirstOutput() {
        return this.firstOutput;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.firstOutput.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.firstOutput.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<GrillRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("furnitury", "grill");

        public GrillRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack firstOutput = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"first_output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new GrillRecipe((NonNullList<Ingredient>)inputs, firstOutput, pRecipeId);
        }

        public GrillRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack firstOutput = pBuffer.m_130267_();
            return new GrillRecipe((NonNullList<Ingredient>)inputs, firstOutput, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, GrillRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.ingredients.size());
            for (Ingredient ingredient : pRecipe.ingredients) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.getFirstOutput(), false);
        }
    }

    public static class Type
    implements RecipeType<GrillRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "grill";
    }
}

