/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.entity.model.DummyModelPart;
import com.supermartijn642.fusion.entity.model.loader.EntityModelLoader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.core.Direction;

public class BedrockEntityModelLoader
implements EntityModelLoader {
    @Override
    public ModelPart loadModel(JsonObject json) {
        if (!json.has("format_version")) {
            throw new JsonParseException("Missing 'format_version'!");
        }
        if (!json.get("format_version").isJsonPrimitive() || !json.getAsJsonPrimitive("format_version").isString()) {
            throw new JsonParseException("Property 'format_version' must be a string!");
        }
        SchemaVersion version = SchemaVersion.fromName(json.get("format_version").getAsString());
        if (version == null) {
            throw new JsonParseException("Unknown 'format_version': '" + json.get("format_version").getAsString() + "'!");
        }
        if (version.ordinal() < SchemaVersion.V1_12_0.ordinal()) {
            throw new JsonParseException("Unsupported 'format_version': '" + version + "'!");
        }
        if (version.ordinal() > SchemaVersion.V1_12_0.ordinal()) {
            FusionClient.LOGGER.warn("Found an entity model with schema version '{}'. In case the model does not load as expected, please report it as a bug to Fusion!", (Object)version);
        }
        if (!json.has("minecraft:geometry")) {
            throw new JsonParseException("Missing 'minecraft:geometry'!");
        }
        if (!json.get("minecraft:geometry").isJsonArray()) {
            throw new JsonParseException("Property 'minecraft:geometry' must be an array!");
        }
        JsonArray geometryArray = json.getAsJsonArray("minecraft:geometry");
        if (geometryArray.isEmpty()) {
            throw new JsonParseException("Array property 'minecraft:geometry' must not be empty!");
        }
        if (!geometryArray.get(0).isJsonObject()) {
            throw new JsonParseException("Array property 'minecraft:geometry' must only contain objects!");
        }
        JsonObject geometryJson = geometryArray.get(0).getAsJsonObject();
        Geometry geometry = BedrockEntityModelLoader.readGeometry(version, geometryJson);
        return geometry.bake();
    }

    private static Geometry readGeometry(SchemaVersion version, JsonObject json) {
        ArrayList<Bone> roots = new ArrayList<Bone>();
        if (!json.has("description") || !json.get("description").isJsonObject()) {
            throw new JsonParseException("Geometry object must have object property 'description'!");
        }
        JsonObject description = json.getAsJsonObject("description");
        if (!(description.has("texture_width") && description.get("texture_width").isJsonPrimitive() && description.getAsJsonPrimitive("texture_width").isNumber())) {
            throw new JsonParseException("Geometry description must have int property 'texture_width'!");
        }
        if (!(description.has("texture_height") && description.get("texture_height").isJsonPrimitive() && description.getAsJsonPrimitive("texture_height").isNumber())) {
            throw new JsonParseException("Geometry description must have int property 'texture_height'!");
        }
        int textureWidth = description.get("texture_width").getAsInt();
        int textureHeight = description.get("texture_height").getAsInt();
        if (textureWidth < 0) {
            throw new JsonParseException("Property 'texture_width' must be greater than zero!");
        }
        if (textureHeight < 0) {
            throw new JsonParseException("Property 'texture_height' must be greater than zero!");
        }
        HashMap<String, Bone> bones = new HashMap<String, Bone>();
        if (json.has("bones")) {
            if (!json.get("bones").isJsonArray()) {
                throw new JsonParseException("Property 'bones' must be an array!");
            }
            JsonArray bonesJson = json.getAsJsonArray("bones");
            for (JsonElement boneJson : bonesJson) {
                if (!boneJson.isJsonObject()) {
                    throw new JsonParseException("Array property 'bones' must only contain objects!");
                }
                Bone bone = BedrockEntityModelLoader.readBone(version, boneJson.getAsJsonObject());
                bones.put(bone.name, bone);
            }
        }
        for (Bone part : bones.values()) {
            if (part.parent == null) {
                roots.add(part);
                continue;
            }
            if (!bones.containsKey(part.parent)) {
                throw new JsonParseException("Missing parent '" + part.parent + "' for bone '" + part.name + "'!");
            }
            Bone parent = (Bone)bones.get(part.parent);
            parent.children.add(part);
        }
        return new Geometry(textureWidth, textureHeight, roots);
    }

    private static Bone readBone(SchemaVersion version, JsonObject json) {
        if (!(json.has("name") && json.get("name").isJsonPrimitive() && json.getAsJsonPrimitive("name").isString())) {
            throw new JsonParseException("Bone must have string property 'name'!");
        }
        String name = json.get("name").getAsString();
        String parent = null;
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.getAsJsonPrimitive("parent").isString()) {
                throw new JsonParseException("Bone property 'parent' must be a string!");
            }
            parent = json.get("parent").getAsString();
        }
        float[] pivot = new float[3];
        if (json.has("pivot")) {
            if (!json.get("pivot").isJsonArray()) {
                throw new JsonParseException("Bone property 'pivot' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("pivot");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Bone property 'pivot' must consist of 3 floats!");
            }
            pivot = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        float[] rotation = new float[3];
        if (json.has("rotation")) {
            if (!json.get("rotation").isJsonArray()) {
                throw new JsonParseException("Bone property 'rotation' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("rotation");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Bone property 'rotation' must consist of 3 floats!");
            }
            rotation = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        boolean mirror = false;
        if (json.has("mirror")) {
            if (!json.get("mirror").isJsonPrimitive() || !json.getAsJsonPrimitive("mirror").isBoolean()) {
                throw new JsonParseException("Bone property 'mirror' must be a boolean!");
            }
            mirror = json.get("mirror").getAsBoolean();
        }
        float inflate = 0.0f;
        if (json.has("inflate")) {
            if (!json.get("inflate").isJsonPrimitive() || !json.getAsJsonPrimitive("inflate").isNumber()) {
                throw new JsonParseException("Bone property 'inflate' must be a number!");
            }
            inflate = json.get("inflate").getAsFloat();
        }
        List<Cube> cubes = List.of();
        if (json.has("cubes")) {
            if (!json.get("cubes").isJsonArray()) {
                throw new JsonParseException("Bone property 'cubes' must be an array!");
            }
            JsonArray cubesJson = json.getAsJsonArray("cubes");
            cubes = new ArrayList(cubesJson.size());
            for (JsonElement element : cubesJson) {
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Bone property 'cubes' must only contain objects!");
                }
                cubes.add(BedrockEntityModelLoader.readCube(version, element.getAsJsonObject()));
            }
        }
        if (json.has("poly_mesh")) {
            throw new JsonParseException("Bone property 'poly_mesh' is not supported!");
        }
        if (json.has("texture_meshes")) {
            throw new JsonParseException("Bone property 'texture_meshes' is not supported!");
        }
        return new Bone(name, parent, pivot, rotation, mirror, inflate, cubes);
    }

    private static Cube readCube(SchemaVersion version, JsonObject json) {
        float[] origin = new float[3];
        if (json.has("origin")) {
            if (!json.get("origin").isJsonArray()) {
                throw new JsonParseException("Cube property 'origin' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("origin");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Cube property 'origin' must consist of 3 floats!");
            }
            origin = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        float[] size = new float[3];
        if (json.has("size")) {
            if (!json.get("size").isJsonArray()) {
                throw new JsonParseException("Cube property 'size' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("size");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Cube property 'size' must consist of 3 floats!");
            }
            size = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        float[] rotation = new float[3];
        if (json.has("rotation")) {
            if (!json.get("rotation").isJsonArray()) {
                throw new JsonParseException("Cube property 'rotation' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("rotation");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Cube property 'rotation' must consist of 3 floats!");
            }
            rotation = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        float[] pivot = new float[3];
        if (json.has("pivot")) {
            if (!json.get("pivot").isJsonArray()) {
                throw new JsonParseException("Cube property 'pivot' must be an array!");
            }
            JsonArray arr = json.getAsJsonArray("pivot");
            if (!(arr.size() == 3 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber() && arr.get(2).isJsonPrimitive() && arr.get(2).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Cube property 'pivot' must consist of 3 floats!");
            }
            pivot = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat()};
        }
        Float inflate = null;
        if (json.has("inflate")) {
            if (!json.get("inflate").isJsonPrimitive() || !json.getAsJsonPrimitive("inflate").isNumber()) {
                throw new JsonParseException("Cube property 'inflate' must be a number!");
            }
            inflate = Float.valueOf(json.get("inflate").getAsFloat());
        }
        Boolean mirror = null;
        if (json.has("mirror")) {
            if (!json.get("mirror").isJsonPrimitive() || !json.getAsJsonPrimitive("mirror").isBoolean()) {
                throw new JsonParseException("Cube property 'mirror' must be a boolean!");
            }
            mirror = json.get("mirror").getAsBoolean();
        }
        EnumMap<Direction, Face> faces = new EnumMap<Direction, Face>(Direction.class);
        if (json.has("uv")) {
            if (json.get("uv").isJsonArray()) {
                JsonArray arr = json.getAsJsonArray("uv");
                if (!(arr.size() == 2 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber())) {
                    throw new JsonParseException("Cube property 'uv' must consist of 2 floats!");
                }
                for (Direction side : Direction.values()) {
                    faces.put(side, new Face(new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat()}, null, 0, false));
                }
            } else if (json.get("uv").isJsonObject()) {
                JsonObject uvJson = json.getAsJsonObject("uv");
                for (Direction side : Direction.values()) {
                    if (!uvJson.has(side.m_122433_())) continue;
                    if (!uvJson.get(side.m_122433_()).isJsonObject()) {
                        throw new JsonParseException("Cube uv for side '" + side.m_122433_() + "' must be an object!");
                    }
                    faces.put(side, BedrockEntityModelLoader.readFace(version, uvJson.getAsJsonObject(side.m_122433_()), side));
                }
            } else {
                throw new JsonParseException("Cube property 'uv' must either be an object or an array!");
            }
        }
        return new Cube(origin, size, rotation, pivot, inflate, mirror, faces);
    }

    private static Face readFace(SchemaVersion version, JsonObject json, Direction side) {
        if (!json.has("uv") || !json.get("uv").isJsonArray()) {
            throw new JsonParseException("Cube uv for side '" + side.m_122433_() + "' must have array property 'uv'!");
        }
        JsonArray arr = json.getAsJsonArray("uv");
        if (!(arr.size() == 2 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber())) {
            throw new JsonParseException("Property 'uv' in cube uv for side '" + side.m_122433_() + "' must consist of 2 floats!");
        }
        float[] uv = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat()};
        float[] size = null;
        if (json.has("uv_size")) {
            if (!json.get("uv_size").isJsonArray()) {
                throw new JsonParseException("Property 'uv_size' in cube uv for side '" + side.m_122433_() + "' must be an array!");
            }
            arr = json.getAsJsonArray("uv_size");
            if (!(arr.size() == 2 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsJsonPrimitive().isNumber() && arr.get(1).isJsonPrimitive() && arr.get(1).getAsJsonPrimitive().isNumber())) {
                throw new JsonParseException("Property 'uv_size' in cube uv for side '" + side.m_122433_() + "' must consist of 2 floats!");
            }
            size = new float[]{arr.get(0).getAsFloat(), arr.get(1).getAsFloat()};
        }
        int rotation = 0;
        if (json.has("uv_rotation")) {
            if (!json.get("uv_rotation").isJsonPrimitive() || !json.getAsJsonPrimitive("uv_rotation").isNumber()) {
                throw new JsonParseException("Property 'uv_rotation' in cube uv for side '" + side.m_122433_() + "' must be an integer!");
            }
            rotation = json.get("uv_rotation").getAsInt();
        }
        return new Face(uv, size, rotation, true);
    }

    private static enum SchemaVersion {
        V1_8_0("1.8.0"),
        V1_12_0("1.12.0"),
        V1_14_0("1.14.0"),
        V1_16_0("1.16.0"),
        V1_19_30("1.19.30"),
        V1_21_0("1.21.0");

        private final String name;

        public static SchemaVersion fromName(String version) {
            for (SchemaVersion value : SchemaVersion.values()) {
                if (!value.name.equals(version)) continue;
                return value;
            }
            return null;
        }

        private SchemaVersion(String name) {
            this.name = name;
        }
    }

    private static class Geometry {
        private final int textureWidth;
        private final int textureHeight;
        private final List<Bone> bones;

        private Geometry(int textureWidth, int textureHeight, List<Bone> bones) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.bones = bones;
        }

        public ModelPart bake() {
            Map<String, ModelPart> children = this.bones.stream().collect(Collectors.toUnmodifiableMap(b -> b.name, b -> b.bake(this.textureWidth, this.textureHeight)));
            return new ModelPart(List.of(), children);
        }
    }

    private static class Bone {
        public final String name;
        public final String parent;
        private final float[] pivot;
        private final float[] rotation;
        private final boolean mirror;
        private final float inflate;
        private final List<Cube> cubes;
        public final List<Bone> children = new ArrayList<Bone>();

        private Bone(String name, String parent, float[] pivot, float[] rotation, boolean mirror, float inflate, List<Cube> cubes) {
            this.name = name;
            this.parent = parent;
            this.pivot = pivot;
            this.rotation = rotation;
            this.mirror = mirror;
            this.inflate = inflate;
            this.cubes = cubes;
        }

        public ModelPart bake(int textureWidth, int textureHeight) {
            HashMap<Object, ModelPart> children = new HashMap<Object, ModelPart>();
            for (Bone bone : this.children) {
                children.put(bone.name, bone.bake(textureWidth, textureHeight));
            }
            int index = 0;
            for (Cube cube : this.cubes) {
                ModelPart part = cube.bake(this, textureWidth, textureHeight);
                while (children.containsKey("Cube " + index)) {
                    ++index;
                }
                children.put("Cube " + index, part);
            }
            ModelPart modelPart = new ModelPart(List.of(), Map.copyOf(children));
            PartPose pose = PartPose.m_171419_((float)this.pivot[0], (float)(-this.pivot[1]), (float)(-this.pivot[2]));
            modelPart.m_233560_(pose);
            modelPart.m_171322_(pose);
            DummyModelPart pivotPart = new DummyModelPart(modelPart);
            pose = PartPose.m_171423_((float)(-this.pivot[0]), (float)this.pivot[1], (float)this.pivot[2], (float)((float)Math.toRadians(-this.rotation[0])), (float)((float)Math.toRadians(-this.rotation[1])), (float)((float)Math.toRadians(this.rotation[2])));
            pivotPart.m_233560_(pose);
            pivotPart.m_171322_(pose);
            return pivotPart;
        }
    }

    private static class Cube {
        private final float[] origin;
        private final float[] size;
        private final float[] rotation;
        private final float[] pivot;
        private final Float inflate;
        private final Boolean mirror;
        private final Map<Direction, Face> uvs;

        private Cube(float[] origin, float[] size, float[] rotation, float[] pivot, Float inflate, Boolean mirror, Map<Direction, Face> uvs) {
            this.origin = origin;
            this.size = size;
            this.rotation = rotation;
            this.pivot = pivot;
            this.inflate = inflate;
            this.mirror = mirror;
            this.uvs = uvs;
        }

        public ModelPart bake(Bone bone, int textureWidth, int textureHeight) {
            float inflate = this.inflate == null ? bone.inflate : this.inflate.floatValue();
            boolean mirror = this.mirror == null ? bone.mirror : this.mirror;
            for (Direction side : Direction.values()) {
                this.uvs.computeIfPresent(side, (s, f) -> new Face(f.uv, f.size, f.rotation, f.sideSpecific));
            }
            ModelPart.Polygon[] polygons = Cube.createPolygons(-this.origin[0] - this.size[0] - this.pivot[0], this.origin[1] + this.pivot[1], this.origin[2] + this.pivot[2], this.size[0], this.size[1], this.size[2], inflate, textureWidth, textureHeight, this.uvs, mirror);
            ModelPart.Cube cube = new ModelPart.Cube(0, 0, -this.origin[0] - this.size[0] - this.pivot[0], this.origin[1] + this.pivot[1], this.origin[2] + this.pivot[2], this.size[0], this.size[1], this.size[2], inflate, inflate, inflate, mirror, 1.0f, 1.0f, this.uvs.keySet());
            System.arraycopy(polygons, 0, cube.f_104341_, 0, this.uvs.size());
            ModelPart part = new ModelPart(List.of(cube), Map.of());
            PartPose pose = PartPose.m_171423_((float)this.pivot[0], (float)(-this.pivot[1]), (float)(-this.pivot[2]), (float)((float)Math.toRadians(-this.rotation[0])), (float)((float)Math.toRadians(-this.rotation[1])), (float)((float)Math.toRadians(this.rotation[2])));
            part.m_233560_(pose);
            part.m_171322_(pose);
            return part;
        }

        private static ModelPart.Polygon[] createPolygons(float startX, float startY, float startZ, float sizeX, float sizeY, float sizeZ, float inflation, int textureWidth, int textureHeight, Map<Direction, Face> faces, boolean mirror) {
            float endX = startX + sizeX + inflation;
            float endY = startY + sizeY + inflation;
            float endZ = startZ + sizeZ + inflation;
            startX -= inflation;
            startY -= inflation;
            startZ -= inflation;
            if (mirror) {
                float f = endX;
                endX = startX;
                startX = f;
            }
            ModelPart.Vertex minXMinYMinZ = new ModelPart.Vertex(startX, startY, startZ, 0.0f, 0.0f);
            ModelPart.Vertex maxXMinYMinZ = new ModelPart.Vertex(endX, startY, startZ, 0.0f, 8.0f);
            ModelPart.Vertex maxXMaxYMinZ = new ModelPart.Vertex(endX, endY, startZ, 8.0f, 8.0f);
            ModelPart.Vertex minXMaxYMinZ = new ModelPart.Vertex(startX, endY, startZ, 8.0f, 0.0f);
            ModelPart.Vertex minXMinYMaxZ = new ModelPart.Vertex(startX, startY, endZ, 0.0f, 0.0f);
            ModelPart.Vertex maxXMinYMaxZ = new ModelPart.Vertex(endX, startY, endZ, 0.0f, 8.0f);
            ModelPart.Vertex maxXMaxYMaxZ = new ModelPart.Vertex(endX, endY, endZ, 8.0f, 8.0f);
            ModelPart.Vertex minXMaxYMaxZ = new ModelPart.Vertex(startX, endY, endZ, 8.0f, 0.0f);
            int polygonIndex = 0;
            ModelPart.Polygon[] polygons = new ModelPart.Polygon[faces.size()];
            if (faces.containsKey(Direction.DOWN)) {
                polygons[polygonIndex++] = Cube.createPolygon(minXMinYMinZ, maxXMinYMinZ, maxXMinYMaxZ, minXMinYMaxZ, sizeX + sizeZ, sizeZ, sizeX + sizeX + sizeZ, 0.0f, sizeX, sizeZ, textureWidth, textureHeight, mirror, Direction.DOWN, faces);
            }
            if (faces.containsKey(Direction.UP)) {
                polygons[polygonIndex++] = Cube.createPolygon(minXMaxYMaxZ, maxXMaxYMaxZ, maxXMaxYMinZ, minXMaxYMinZ, sizeZ, 0.0f, sizeX + sizeZ, sizeZ, sizeX, sizeZ, textureWidth, textureHeight, mirror, Direction.UP, faces);
            }
            if (faces.containsKey(Direction.WEST)) {
                polygons[polygonIndex++] = Cube.createPolygon(minXMaxYMaxZ, minXMaxYMinZ, minXMinYMinZ, minXMinYMaxZ, sizeX + sizeZ, sizeZ, sizeX + sizeZ + sizeZ, sizeY + sizeZ, sizeZ, sizeY, textureWidth, textureHeight, mirror, Direction.WEST, faces);
            }
            if (faces.containsKey(Direction.NORTH)) {
                polygons[polygonIndex++] = Cube.createPolygon(minXMaxYMinZ, maxXMaxYMinZ, maxXMinYMinZ, minXMinYMinZ, sizeZ, sizeZ, sizeX + sizeZ, sizeY + sizeZ, sizeX, sizeY, textureWidth, textureHeight, mirror, Direction.NORTH, faces);
            }
            if (faces.containsKey(Direction.EAST)) {
                polygons[polygonIndex++] = Cube.createPolygon(maxXMaxYMinZ, maxXMaxYMaxZ, maxXMinYMaxZ, maxXMinYMinZ, 0.0f, sizeZ, sizeZ, sizeY + sizeZ, sizeZ, sizeY, textureWidth, textureHeight, mirror, Direction.EAST, faces);
            }
            if (faces.containsKey(Direction.SOUTH)) {
                polygons[polygonIndex] = Cube.createPolygon(maxXMaxYMaxZ, minXMaxYMaxZ, minXMinYMaxZ, maxXMinYMaxZ, sizeX + sizeZ + sizeZ, sizeZ, sizeX + sizeX + sizeZ + sizeZ, sizeY + sizeZ, sizeX, sizeY, textureWidth, textureHeight, mirror, Direction.SOUTH, faces);
            }
            return polygons;
        }

        private static ModelPart.Polygon createPolygon(ModelPart.Vertex vertex0, ModelPart.Vertex vertex1, ModelPart.Vertex vertex2, ModelPart.Vertex vertex3, float u0, float v0, float u1, float v1, float width, float height, int textureWidth, int textureHeight, boolean mirror, Direction side, Map<Direction, Face> faces) {
            Face face = faces.get(Direction.DOWN);
            if (face.sideSpecific) {
                float[] fArray;
                if (face.size == null) {
                    float[] fArray2 = new float[2];
                    fArray2[0] = width;
                    fArray = fArray2;
                    fArray2[1] = height;
                } else {
                    fArray = face.size;
                }
                float[] uvSize = fArray;
                u0 = face.uv[0];
                u1 = face.uv[0] + uvSize[0];
                v0 = face.uv[1];
                v1 = face.uv[1] + uvSize[1];
            } else {
                u0 += face.uv[0];
                u1 += face.uv[0];
                v0 += face.uv[1];
                v1 += face.uv[1];
            }
            return new ModelPart.Polygon(new ModelPart.Vertex[]{vertex0, vertex1, vertex2, vertex3}, u0, v0, u1, v1, (float)textureWidth, (float)textureHeight, mirror, Direction.DOWN);
        }
    }

    private static class Face {
        private final float[] uv;
        private final float[] size;
        private final int rotation;
        private final boolean sideSpecific;

        private Face(float[] uv, float[] size, int rotation, boolean sideSpecific) {
            this.uv = uv;
            this.size = size;
            this.rotation = rotation;
            this.sideSpecific = sideSpecific;
        }
    }
}

