/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasinBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty WATER_LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);
    private static final VoxelShape INSIDE = BasinBlock.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)INSIDE, (BooleanOp)BooleanOp.f_82685_);

    public BasinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATER_LEVEL});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return INSIDE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack held = player.m_21120_(hand);
        int currentLevel = (Integer)state.m_61143_((Property)WATER_LEVEL);
        boolean changed = false;
        ItemStack waterBottle = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
        if (held.m_41720_() == waterBottle.m_41720_()) {
            if (currentLevel < 3) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(Math.min(currentLevel + 1, 3))), 3);
                if (!player.m_150110_().f_35937_) {
                    held.m_41774_(1);
                    level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_36356_(new ItemStack((ItemLike)Items.f_42590_));
                }
                changed = true;
            }
        } else if (held.m_41720_() == Items.f_42447_) {
            if (currentLevel < 3) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(Math.min(currentLevel + 3, 3))), 3);
                if (!player.m_150110_().f_35937_) {
                    level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                changed = true;
            }
        } else if (held.m_41720_() == Items.f_42590_) {
            if (currentLevel >= 1) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(currentLevel - 1)), 3);
                if (!player.m_150110_().f_35937_) {
                    held.m_41774_(1);
                    level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_36356_(waterBottle);
                }
                changed = true;
            }
        } else if (held.m_41720_() == Items.f_42446_ && currentLevel >= 3) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(currentLevel - 3)), 3);
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
                level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_36356_(new ItemStack((ItemLike)Items.f_42447_));
            }
            changed = true;
        }
        return changed ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_ && !level.m_276867_(pos)) {
            level.m_186460_(pos, (Block)this, 60);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            boolean powered = level.m_276867_(pos);
            boolean scheduled = level.m_183326_().m_183582_(pos, (Object)this);
            if (!powered && !scheduled && (Integer)state.m_61143_((Property)WATER_LEVEL) < 3) {
                level.m_186460_(pos, (Block)this, 60);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_276867_(pos)) {
            return;
        }
        int currentLevel = (Integer)state.m_61143_((Property)WATER_LEVEL);
        if (currentLevel < 3) {
            int newLevel = currentLevel + 1;
            BlockState newState = (BlockState)state.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(newLevel));
            level.m_7731_(pos, newState, 3);
            level.m_5594_(null, pos, SoundEvents.f_11938_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (newLevel < 3) {
                level.m_186460_(pos, (Block)this, 60);
            }
        }
    }
}

