/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.crafting;

import alabaster.hearthandharvest.HearthAndHarvest;
import alabaster.hearthandharvest.client.recipebook.CaskRecipeBookTab;
import alabaster.hearthandharvest.common.registry.HHModItems;
import alabaster.hearthandharvest.common.registry.HHModRecipeSerializers;
import alabaster.hearthandharvest.common.registry.HHModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CaskRecipe
implements Recipe<RecipeWrapper> {
    public static final int INPUT_SLOTS = 4;
    private final ResourceLocation id;
    private final String group;
    private final CaskRecipeBookTab tab;
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final float experience;
    private final int cookTime;

    public CaskRecipe(ResourceLocation id, String group, @Nullable CaskRecipeBookTab tab, NonNullList<Ingredient> inputItems, ItemStack output, float experience, int cookTime) {
        this.id = id;
        this.group = group;
        this.tab = tab;
        this.inputItems = inputItems;
        this.output = output;
        this.experience = experience;
        this.cookTime = cookTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    @Nullable
    public CaskRecipeBookTab getRecipeBookTab() {
        return this.tab;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output;
    }

    public ItemStack assemble(RecipeWrapper inv, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public RecipeSerializer<?> m_7707_() {
        return HHModRecipeSerializers.AGING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)HHModRecipeTypes.AGING.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)HHModItems.CASK.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaskRecipe that = (CaskRecipe)o;
        if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
            return false;
        }
        if (this.getCookTime() != that.getCookTime()) {
            return false;
        }
        if (!this.m_6423_().equals((Object)that.m_6423_())) {
            return false;
        }
        if (!this.m_6076_().equals(that.m_6076_())) {
            return false;
        }
        if (this.tab != that.tab) {
            return false;
        }
        if (!this.inputItems.equals(that.inputItems)) {
            return false;
        }
        return this.output.equals(that.output);
    }

    public int hashCode() {
        int result = this.m_6423_().hashCode();
        result = 31 * result + this.m_6076_().hashCode();
        result = 31 * result + (this.getRecipeBookTab() != null ? this.getRecipeBookTab().hashCode() : 0);
        result = 31 * result + this.inputItems.hashCode();
        result = 31 * result + this.output.hashCode();
        result = 31 * result + (this.getExperience() != 0.0f ? Float.floatToIntBits(this.getExperience()) : 0);
        result = 31 * result + this.getCookTime();
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<CaskRecipe> {
        public CaskRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String groupIn = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cooking recipe");
            }
            if (inputItemsIn.size() > 4) {
                throw new JsonParseException("Too many ingredients for cooking recipe! The max is 4");
            }
            String tabKeyIn = GsonHelper.m_13851_((JsonObject)json, (String)"recipe_book_tab", null);
            CaskRecipeBookTab tabIn = CaskRecipeBookTab.findByName(tabKeyIn);
            if (tabKeyIn != null && tabIn == null) {
                HearthAndHarvest.LOGGER.warn("Optional field 'recipe_book_tab' does not match any valid tab. If defined, must be one of the following: " + String.valueOf(EnumSet.allOf(CaskRecipeBookTab.class)));
            }
            ItemStack outputIn = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            float experienceIn = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int cookTimeIn = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)200);
            return new CaskRecipe(recipeId, groupIn, tabIn, inputItemsIn, outputIn, experienceIn, cookTimeIn);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public CaskRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String groupIn = buffer.m_130277_();
            CaskRecipeBookTab tabIn = CaskRecipeBookTab.findByName(buffer.m_130277_());
            int i = buffer.m_130242_();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack outputIn = buffer.m_130267_();
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.m_130242_();
            return new CaskRecipe(recipeId, groupIn, tabIn, (NonNullList<Ingredient>)inputItemsIn, outputIn, experienceIn, cookTimeIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, CaskRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130070_(recipe.tab != null ? recipe.tab.toString() : "");
            buffer.m_130130_(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.writeFloat(recipe.experience);
            buffer.m_130130_(recipe.cookTime);
        }
    }
}

