/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.entity.goal;

import alabaster.hearthandharvest.common.registry.HHModEffects;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.phys.Vec3;

public class PungentEffectGoal
extends Goal {
    private final Mob mob;
    private LivingEntity pungentSource;
    private final double farSpeed;
    private final double nearSpeed;
    private final double baseRadius;

    public PungentEffectGoal(Mob mob, double farSpeed, double nearSpeed, double baseRadius) {
        this.mob = mob;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.baseRadius = baseRadius;
    }

    private double getEffectiveRadius() {
        if (this.pungentSource != null && this.pungentSource.m_21023_((MobEffect)HHModEffects.PUNGENT.get())) {
            int amplifier = this.pungentSource.m_21124_((MobEffect)HHModEffects.PUNGENT.get()).m_19564_();
            return this.baseRadius * (1.0 + 0.5 * (double)amplifier);
        }
        return this.baseRadius;
    }

    public boolean m_8036_() {
        List candidates = this.mob.m_9236_().m_6443_(LivingEntity.class, this.mob.m_20191_().m_82400_(this.baseRadius), entity -> entity != this.mob && entity.m_21023_((MobEffect)HHModEffects.PUNGENT.get()));
        if (!candidates.isEmpty()) {
            this.pungentSource = candidates.stream().min(Comparator.comparingDouble(arg_0 -> ((Mob)this.mob).m_20280_(arg_0))).orElse(null);
            return this.pungentSource != null;
        }
        return false;
    }

    public boolean m_8045_() {
        double effectiveRadius = this.getEffectiveRadius();
        return this.pungentSource != null && this.mob.m_20280_((Entity)this.pungentSource) < effectiveRadius * effectiveRadius;
    }

    public void m_8056_() {
        this.fleeFromSource();
    }

    public void m_8037_() {
        if (this.pungentSource != null) {
            this.fleeFromSource();
        }
    }

    private void fleeFromSource() {
        double effectiveRadius = this.getEffectiveRadius();
        Vec3 direction = new Vec3(this.mob.m_20185_() - this.pungentSource.m_20185_(), 0.0, this.mob.m_20189_() - this.pungentSource.m_20189_()).m_82541_();
        double targetX = this.mob.m_20185_() + direction.f_82479_ * effectiveRadius;
        double targetZ = this.mob.m_20189_() + direction.f_82481_ * effectiveRadius;
        PathNavigation navigation = this.mob.m_21573_();
        navigation.m_26519_(targetX, this.mob.m_20186_(), targetZ, this.mob.m_20280_((Entity)this.pungentSource) < 16.0 ? this.nearSpeed : this.farSpeed);
    }

    public void m_8041_() {
        this.pungentSource = null;
    }
}

