/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.data;

import alabaster.hearthandharvest.common.block.BlueberryBushBlock;
import alabaster.hearthandharvest.common.block.BuddingRedGrapeBlock;
import alabaster.hearthandharvest.common.block.CottonBlock;
import alabaster.hearthandharvest.common.block.JarBlock;
import alabaster.hearthandharvest.common.block.PeanutBlock;
import alabaster.hearthandharvest.common.block.RaspberryBushBlock;
import alabaster.hearthandharvest.common.registry.HHModBlocks;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class BlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public BlockStates(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "hearthandharvest", existingFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("hearthandharvest", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.halfCabinetBlock((Block)HHModBlocks.OAK_HALF_CABINET.get(), "oak");
        this.halfCabinetBlock((Block)HHModBlocks.BIRCH_HALF_CABINET.get(), "birch");
        this.halfCabinetBlock((Block)HHModBlocks.SPRUCE_HALF_CABINET.get(), "spruce");
        this.halfCabinetBlock((Block)HHModBlocks.JUNGLE_HALF_CABINET.get(), "jungle");
        this.halfCabinetBlock((Block)HHModBlocks.ACACIA_HALF_CABINET.get(), "acacia");
        this.halfCabinetBlock((Block)HHModBlocks.DARK_OAK_HALF_CABINET.get(), "dark_oak");
        this.halfCabinetBlock((Block)HHModBlocks.MANGROVE_HALF_CABINET.get(), "mangrove");
        this.halfCabinetBlock((Block)HHModBlocks.CHERRY_HALF_CABINET.get(), "cherry");
        this.halfCabinetBlock((Block)HHModBlocks.BAMBOO_HALF_CABINET.get(), "bamboo");
        this.halfCabinetBlock((Block)HHModBlocks.CRIMSON_HALF_CABINET.get(), "crimson");
        this.halfCabinetBlock((Block)HHModBlocks.WARPED_HALF_CABINET.get(), "warped");
        this.wineRackBlock((Block)HHModBlocks.OAK_WINE_RACK.get(), "oak");
        this.wineRackBlock((Block)HHModBlocks.BIRCH_WINE_RACK.get(), "birch");
        this.wineRackBlock((Block)HHModBlocks.SPRUCE_WINE_RACK.get(), "spruce");
        this.wineRackBlock((Block)HHModBlocks.JUNGLE_WINE_RACK.get(), "jungle");
        this.wineRackBlock((Block)HHModBlocks.ACACIA_WINE_RACK.get(), "acacia");
        this.wineRackBlock((Block)HHModBlocks.DARK_OAK_WINE_RACK.get(), "dark_oak");
        this.wineRackBlock((Block)HHModBlocks.MANGROVE_WINE_RACK.get(), "mangrove");
        this.wineRackBlock((Block)HHModBlocks.CHERRY_WINE_RACK.get(), "cherry");
        this.wineRackBlock((Block)HHModBlocks.BAMBOO_WINE_RACK.get(), "bamboo");
        this.wineRackBlock((Block)HHModBlocks.CRIMSON_WINE_RACK.get(), "crimson");
        this.wineRackBlock((Block)HHModBlocks.WARPED_WINE_RACK.get(), "warped");
        this.crateBlock((Block)HHModBlocks.CHERRY_CRATE.get(), "cherry");
        this.crateBlock((Block)HHModBlocks.BLUEBERRY_CRATE.get(), "blueberry");
        this.crateBlock((Block)HHModBlocks.RASPBERRY_CRATE.get(), "raspberry");
        this.crateBlock((Block)HHModBlocks.RED_GRAPE_CRATE.get(), "red_grape");
        this.crateBlock((Block)HHModBlocks.GREEN_GRAPE_CRATE.get(), "green_grape");
        this.crateBlock((Block)HHModBlocks.PEANUT_CRATE.get(), "peanut");
        this.crateBlock((Block)HHModBlocks.APPLE_CRATE.get(), "apple");
        this.crateBlock((Block)HHModBlocks.GOLDEN_APPLE_CRATE.get(), "golden_apple");
        this.crateBlock((Block)HHModBlocks.GOLDEN_CARROT_CRATE.get(), "golden_carrot");
        this.crateBlock((Block)HHModBlocks.POISONOUS_POTATO_CRATE.get(), "poisonous_potato");
        this.crateBlock((Block)HHModBlocks.GLOW_BERRY_CRATE.get(), "glow_berry");
        this.crateBlock((Block)HHModBlocks.SWEET_BERRY_CRATE.get(), "sweet_berry");
        this.customStageBlock((Block)HHModBlocks.RASPBERRY_BUSH.get(), this.resourceBlock("crop_cross"), "cross", RaspberryBushBlock.f_57244_, Arrays.asList(0, 1, 2, 3, 3), new Property[0]);
        this.customStageBlock((Block)HHModBlocks.BLUEBERRY_BUSH.get(), this.resourceBlock("crop_cross"), "cross", BlueberryBushBlock.f_57244_, Arrays.asList(0, 1, 2, 3, 3), new Property[0]);
        this.customStageBlock((Block)HHModBlocks.BUDDING_RED_GRAPE_CROP.get(), this.resourceBlock("crop_cross"), "cross", BuddingRedGrapeBlock.AGE, Arrays.asList(0, 1, 2, 3, 3), new Property[0]);
        this.customStageBlock((Block)HHModBlocks.BUDDING_GREEN_GRAPE_CROP.get(), this.resourceBlock("crop_cross"), "cross", BuddingRedGrapeBlock.AGE, Arrays.asList(0, 1, 2, 3, 3), new Property[0]);
        this.customStageBlock((Block)HHModBlocks.PEANUT_CROP.get(), this.mcLoc("crop"), "crop", PeanutBlock.f_52244_, Arrays.asList(0, 0, 1, 1, 2, 2, 2, 3), new Property[0]);
        this.customStageBlock((Block)HHModBlocks.COTTON_CROP.get(), this.resourceBlock("crop_cross"), "cross", CottonBlock.f_52244_, Arrays.asList(0, 0, 1, 1, 2, 2, 2, 3), new Property[0]);
        this.pieBlock((Block)HHModBlocks.RASPBERRY_PIE.get());
        this.pieBlock((Block)HHModBlocks.BLUEBERRY_PIE.get());
        this.pieBlock((Block)HHModBlocks.GRAPE_PIE.get());
        this.pieBlock((Block)HHModBlocks.PEANUT_BUTTER_PIE.get());
        this.pieBlock((Block)HHModBlocks.CHICKEN_POT_PIE.get());
        this.axisBlock((RotatedPillarBlock)HHModBlocks.ROPE_COIL.get());
        this.axisBlock((RotatedPillarBlock)HHModBlocks.COTTON_BALE.get());
        this.axisBlock((RotatedPillarBlock)HHModBlocks.SPOOL.get());
        this.bagBlock((Block)HHModBlocks.SALT_BAG.get(), "salt");
        this.bagBlock((Block)HHModBlocks.SUGAR_BAG.get(), "sugar");
        this.bagBlock((Block)HHModBlocks.COCOA_BEAN_BAG.get(), "cocoa_bean");
        this.bagBlock((Block)HHModBlocks.GUNPOWDER_BAG.get(), "gunpowder");
        this.wildCropBlock((Block)HHModBlocks.WILD_RED_GRAPES.get());
        this.wildCropBlock((Block)HHModBlocks.WILD_GREEN_GRAPES.get());
        this.wildCropBlock((Block)HHModBlocks.WILD_COTTON.get());
        this.wildCropBlock((Block)HHModBlocks.WILD_PEANUTS.get());
        this.jarBlock((Block)HHModBlocks.BLUEBERRY_JAM.get(), "blueberry_jam");
        this.jarBlock((Block)HHModBlocks.CHERRY_JAM.get(), "cherry_jam");
        this.jarBlock((Block)HHModBlocks.GRAPE_JAM.get(), "grape_jam");
        this.jarBlock((Block)HHModBlocks.RASPBERRY_JAM.get(), "raspberry_jam");
        this.jarBlock((Block)HHModBlocks.APPLE_JAM.get(), "apple_jam");
        this.jarBlock((Block)HHModBlocks.SWEET_BERRY_JAM.get(), "sweet_berry_jam");
        this.jarBlock((Block)HHModBlocks.GLOW_BERRY_JAM.get(), "glow_berry_jam");
        this.jarBlock((Block)HHModBlocks.MELON_JAM.get(), "melon_jam");
        this.jarBlock((Block)HHModBlocks.PEANUT_BUTTER.get(), "peanut_butter");
        this.jarBlock((Block)HHModBlocks.PICKLED_BEETROOTS.get(), "pickled_beetroots");
        this.jarBlock((Block)HHModBlocks.PICKLED_CABBAGE.get(), "pickled_cabbage");
        this.jarBlock((Block)HHModBlocks.PICKLED_CARROTS.get(), "pickled_carrots");
        this.jarBlock((Block)HHModBlocks.PICKLED_ONIONS.get(), "pickled_onions");
        this.jarBlock((Block)HHModBlocks.PICKLED_POTATOES.get(), "pickled_potatoes");
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().singleTexture(stageName, parent, textureKey, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void halfCabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            String modelName = woodType + "_half_cabinet" + suffix;
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelName)).parent(this.existingModel("half_cabinet"))).texture("front", this.resourceBlock(woodType + "_cabinet_front" + suffix))).texture("side", this.resourceBlock(woodType + "_half_cabinet_side"))).texture("top", this.resourceBlock(woodType + "_half_cabinet_top"))).texture("back", this.resourceBlock(woodType + "_cabinet_side"));
        });
    }

    public void wineRackBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String modelName = woodType + "_wine_rack";
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelName)).parent(this.existingModel("wine_rack"))).texture("side", this.resourceBlock(woodType + "_cabinet_side"))).texture("rack_side", this.resourceBlock(woodType + "_wine_rack_side"))).texture("rack_top", this.resourceBlock(woodType + "_wine_rack_top"));
        });
    }

    public void wildCropBlock(Block block) {
        this.wildCropBlock(block, false);
    }

    public void wildCropBlock(Block block, boolean isBushCrop) {
        if (isBushCrop) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.blockName(block), this.resourceBlock("bush_crop"), "crop", this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        } else {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        }
    }

    public void crateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock(cropName + "_crate_side"), this.resourceBlock("crate_bottom"), this.resourceBlock(cropName + "_crate_top")));
    }

    public void bagBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cube(this.blockName(block), this.resourceBlock("bag_bottom"), this.resourceBlock(cropName + "_bag_top"), this.resourceBlock("bag_side_tied"), this.resourceBlock("bag_side_tied"), this.resourceBlock("bag_side"), this.resourceBlock("bag_side"))).texture("particle", this.resourceBlock(cropName + "_bag_top")));
    }

    public void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    public void jarBlock(Block block, String jarType) {
        int i;
        String baseModelPath = "hearthandharvest:block/" + jarType;
        String modelTexture = "hearthandharvest:block/" + jarType + "_jar";
        for (i = 1; i <= 4; ++i) {
            String modelName = jarType + "_jar_" + i;
            String parentModel = "hearthandharvest:block/generic_jar_" + i;
            ((BlockModelBuilder)this.models().withExistingParent(modelName, parentModel)).texture("lid", modelTexture);
        }
        for (i = 1; i <= 4; ++i) {
            String modelPath = "hearthandharvest:block/" + jarType + "_jar_" + i;
            ModelFile.ExistingModelFile model = this.models().getExistingFile(new ResourceLocation("hearthandharvest", jarType + "_jar_" + i));
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)model).rotationY(this.getYRotation(dir)).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{dir}).condition((Property)JarBlock.JARS, (Comparable[])new Integer[]{i, 4});
            }
        }
    }

    private int getYRotation(Direction direction) {
        return switch (direction) {
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
    }

    private String buildJarsCondition(int minLevel) {
        StringBuilder builder = new StringBuilder();
        for (int j = minLevel; j <= 4; ++j) {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(j);
        }
        return builder.toString();
    }
}

