/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.widgets;

import java.util.List;
import java.util.function.Consumer;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.Utils;
import net.conczin.immersive_furniture.client.gui.widgets.ColorSliderWidget;
import net.conczin.immersive_furniture.client.gui.widgets.TexturedColorSliderWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class HSVColorPicker
extends AbstractWidget {
    private final ColorSliderWidget hueSlider;
    private final ColorSliderWidget saturationSlider;
    private final ColorSliderWidget valueSlider;
    private int color;
    private float hue;
    private float saturation;
    private float value;
    private final Consumer<Integer> callback;

    public HSVColorPicker(int x, int y, int width, int height, int color, Consumer<Integer> callback) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        this.color = color;
        float[] hsv = Utils.rgbToHsv(color);
        this.hue = hsv[0];
        this.saturation = hsv[1];
        this.value = hsv[2];
        this.callback = callback;
        int sliderHeight = (height - 6) / 3;
        this.hueSlider = new TexturedColorSliderWidget(x, y + 1, width, sliderHeight, this.hue / 360.0f, Common.locate("textures/gui/hue.png"), v -> {
            this.hue = v.floatValue() * 360.0f;
            this.update();
        });
        this.saturationSlider = new ColorSliderWidget(x, y + 3 + sliderHeight, width, sliderHeight, this.saturation, v -> {
            this.saturation = v.floatValue();
            this.update();
        });
        this.valueSlider = new ColorSliderWidget(x, y + 5 + 2 * sliderHeight, width, sliderHeight, this.value, v -> {
            this.value = v.floatValue();
            this.update();
        });
        this.update();
    }

    private void update() {
        this.color = Utils.hsvToRgb(this.hue, this.saturation, this.value);
        this.saturationSlider.setColor(-16777216 + Utils.hsvToRgb(this.hue, 0.0f, 1.0f), -16777216 + Utils.hsvToRgb(this.hue, 1.0f, 1.0f));
        this.valueSlider.setColor(-16777216, -16777216 + Utils.hsvToRgb(this.hue, 1.0f, 1.0f));
        this.callback.accept(FastColor.ARGB32.m_13660_((int)255, (int)FastColor.ABGR32.m_266313_((int)this.color), (int)FastColor.ABGR32.m_266446_((int)this.color), (int)FastColor.ABGR32.m_266247_((int)this.color)));
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    public List<AbstractWidget> getWidgets() {
        return List.of(this, this.hueSlider, this.saturationSlider, this.valueSlider);
    }
}

