/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.TransparencyType;
import net.conczin.immersive_furniture.mixin.client.SpriteContentsAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TransparencyManager {
    public static final TransparencyManager INSTANCE = new TransparencyManager();
    private final Map<ResourceLocation, TransparencyType> transparencyCache = new ConcurrentHashMap<ResourceLocation, TransparencyType>();

    public TransparencyType getTransparencyType(SpriteContents s) {
        return this.transparencyCache.computeIfAbsent(s.m_246162_(), location -> this.compute(s));
    }

    public boolean isCornerTransparent(SpriteContents s) {
        NativeImage image = ((SpriteContentsAccessor)s).getMipLevelData()[0];
        return FastColor.ABGR32.m_266503_((int)image.m_84985_(0, 0)) < 128 && FastColor.ABGR32.m_266503_((int)image.m_84985_(image.m_84982_() - 1, 0)) < 128 && FastColor.ABGR32.m_266503_((int)image.m_84985_(image.m_84982_() - 1, image.m_85084_() - 1)) < 128 && FastColor.ABGR32.m_266503_((int)image.m_84985_(0, image.m_85084_() - 1)) < 128;
    }

    private TransparencyType compute(SpriteContents s) {
        NativeImage image = ((SpriteContentsAccessor)s).getMipLevelData()[0];
        boolean hasTransparency = false;
        for (int y = 0; y < image.m_85084_(); ++y) {
            for (int x = 0; x < image.m_84982_(); ++x) {
                int alpha = FastColor.ABGR32.m_266503_((int)image.m_84985_(x, y));
                if (alpha == 0) {
                    hasTransparency = true;
                    continue;
                }
                if (alpha >= 255) continue;
                return TransparencyType.TRANSLUCENT;
            }
        }
        return hasTransparency ? TransparencyType.CUTOUT_MIPPED : TransparencyType.SOLID;
    }

    public static void prepare(FurnitureData data) {
        for (FurnitureData.Element element : data.elements) {
            if (element.type != FurnitureData.ElementType.ELEMENT) continue;
            BlockState state = ((Block)BuiltInRegistries.f_256975_.m_7745_(element.material.source)).m_49966_();
            RenderType renderType = ItemBlockRenderTypes.m_109282_((BlockState)state);
            element.material.transparency = TransparencyManager.fromRenderType(renderType);
        }
    }

    public static TransparencyType fromRenderType(RenderType renderType) {
        if (renderType == RenderType.m_110466_()) {
            return TransparencyType.TRANSLUCENT;
        }
        if (renderType == RenderType.m_110457_()) {
            return TransparencyType.CUTOUT_MIPPED;
        }
        if (renderType == RenderType.m_110463_()) {
            return TransparencyType.CUTOUT;
        }
        return TransparencyType.SOLID;
    }

    public static TransparencyType fromSprite(FurnitureData.Element element) {
        TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        TextureAtlasSprite sprite = atlas.m_118316_(element.sprite.sprite);
        return INSTANCE.getTransparencyType(sprite.m_245424_());
    }

    public static void heySodiumImInUse(FurnitureData data) {
        for (FurnitureData.Element element : data.elements) {
            if (element.type != FurnitureData.ElementType.SPRITE) continue;
            TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
            atlas.m_118316_(element.sprite.sprite);
        }
    }
}

