/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity.misc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_machinery.client.render.entity.renderer.PathDebugRenderer;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.joml.Vector3d;

public class PilotNavigator {
    private final int followRange = 128;
    private final VehicleEntity vehicle;
    private final Mob pilot;
    private final PathFinder pathFinder;
    private final double speed;
    private final boolean isFlying;
    private final int accuracy;
    private BlockPos target;
    private Path currentPath;
    private int stuckTime;
    Cache<Object, Object> pathCache = CacheBuilder.newBuilder().maximumSize(256L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public PilotNavigator(InventoryVehicleEntity vehicle, boolean isFlying, int accuracy) {
        this.vehicle = vehicle;
        this.pilot = new Bee(EntityType.f_20550_, vehicle.m_9236_());
        AttributeInstance instance = this.pilot.m_21204_().m_22146_(Attributes.f_22277_);
        if (instance != null) {
            instance.m_22100_(128.0);
        }
        FlyNodeEvaluator nodeEvaluator = isFlying ? new FlyNodeEvaluator() : new WalkNodeEvaluator();
        this.pathFinder = new PathFinder((NodeEvaluator)nodeEvaluator, 2048);
        this.speed = vehicle.getProperties().get(VehicleStat.ENGINE_SPEED);
        this.isFlying = isFlying;
        this.accuracy = accuracy;
    }

    public Vector3d getDirection() {
        BlockPos node = this.currentPath.m_77392_() ? this.currentPath.m_77406_() : this.currentPath.m_77400_();
        double dx = (double)node.m_123341_() - this.vehicle.m_20185_() + 0.5;
        double dy = this.isFlying ? (double)node.m_123342_() - (this.vehicle.m_20186_() + (double)(this.vehicle.m_20206_() / 2.0f)) + 0.5 : 0.0;
        double dz = (double)node.m_123343_() - this.vehicle.m_20189_() + 0.5;
        return new Vector3d(dx, dy, dz);
    }

    public void moveTo(BlockPos pos) {
        if (!pos.equals((Object)this.target) && !pos.equals((Object)this.vehicle.m_20183_())) {
            this.target = pos;
            this.stuckTime = 0;
            this.currentPath = this.findPath(pos);
            if (this.currentPath != null && (double)this.currentPath.m_77407_() > (double)this.accuracy + 0.5) {
                this.currentPath = null;
            }
            PathDebugRenderer.INSTANCE.setPath(this.currentPath, this.vehicle);
        }
    }

    private Path findPath(BlockPos pos) {
        int i;
        Index index = new Index(this.vehicle.m_20183_(), pos);
        Path path = (Path)this.pathCache.getIfPresent((Object)index);
        if (path == null) {
            this.pilot.m_6034_(this.vehicle.m_20185_(), this.vehicle.m_20186_(), this.vehicle.m_20189_());
            BlockPos blockPos = this.vehicle.m_20183_();
            i = 136;
            PathNavigationRegion pathNavigationRegion = new PathNavigationRegion(this.vehicle.m_9236_(), blockPos.m_7918_(-i, -i, -i), blockPos.m_7918_(i, i, i));
            path = this.pathFinder.m_77427_(pathNavigationRegion, this.pilot, Set.of(pos), 128.0f, this.accuracy, 1.0f);
            if (path == null) {
                return null;
            }
            this.pathCache.put((Object)index, (Object)path);
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (i = 0; i < path.m_77398_(); ++i) {
            nodes.add(path.m_77375_(i));
        }
        return new Path(nodes, path.m_77406_(), false);
    }

    public void tick() {
        if (this.currentPath != null) {
            this.followThePath();
            this.unstuck();
        } else {
            this.move(0.0, 0.0, 0.0);
        }
    }

    protected void followThePath() {
        double margin;
        Vector3d d = this.getDirection();
        double distance = d.length();
        if (distance < (margin = 0.1)) {
            if (this.currentPath.m_77392_()) {
                this.currentPath = null;
                this.target = null;
            } else {
                this.currentPath.m_77374_();
                this.stuckTime = 0;
            }
        }
        double s = this.speed / (distance + 1.0E-5);
        s = Math.min(s, distance);
        this.move(d.x * s, d.y * s, d.z * s);
    }

    private void move(double x, double y, double z) {
        this.vehicle.m_20334_(x, y, z);
    }

    private void unstuck() {
        ++this.stuckTime;
        if (this.stuckTime >= 100 && this.currentPath != null) {
            this.currentPath = null;
            this.target = null;
        }
    }

    public boolean hasPath() {
        return this.currentPath != null;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    record Index(BlockPos pos1, BlockPos pos2) {
    }
}

