/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.core.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class WeakList<T> {
    private final List<WeakReference<T>> list = new ArrayList<WeakReference<T>>();

    public void add(T item) {
        this.list.add(new WeakReference<T>(item));
    }

    public void forEach(Consumer<T> consumer) {
        Iterator<WeakReference<T>> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            WeakReference<T> reference = iterator.next();
            Object item = reference.get();
            if (item == null) {
                iterator.remove();
                continue;
            }
            consumer.accept(item);
        }
    }

    public boolean isEmpty() {
        Iterator<WeakReference<T>> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            WeakReference<T> reference = iterator.next();
            Object item = reference.get();
            if (item == null) {
                iterator.remove();
                continue;
            }
            return false;
        }
        return true;
    }
}

