/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.compat.botania;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import net.dragonegg.moreburners.config.CommonConfig;
import net.dragonegg.moreburners.mixin.accessor.BlazeBurnerBlockEntityAccessor;
import vazkii.botania.api.block.ExoflameHeatable;

public class BlazeBurnerExoflameHeatable
implements ExoflameHeatable {
    public static int BOOST_RATE = (Integer)CommonConfig.EXOFLAME_BOOST_RATE.get();
    public static int SEETHING_BOOST_RATE = (Integer)CommonConfig.EXOFLAME_SEETHING_BOOST_RATE.get();
    private final BlazeBurnerBlockEntity burner;

    public BlazeBurnerExoflameHeatable(BlazeBurnerBlockEntity burner) {
        this.burner = burner;
    }

    public boolean canSmelt() {
        if (this.burner.isCreative()) {
            return false;
        }
        BlazeBurnerBlockEntity.FuelType fuel = this.burner.getActiveFuel();
        return switch (fuel) {
            default -> throw new IncompatibleClassChangeError();
            case BlazeBurnerBlockEntity.FuelType.NONE -> true;
            case BlazeBurnerBlockEntity.FuelType.NORMAL, BlazeBurnerBlockEntity.FuelType.SPECIAL -> this.getBurnTime() < 10000;
        };
    }

    public int getBurnTime() {
        return this.burner.getRemainingBurnTime();
    }

    public void boostBurnTime() {
        BlazeBurnerBlockEntity.FuelType fuel = this.burner.getActiveFuel();
        if (fuel == BlazeBurnerBlockEntity.FuelType.NONE) {
            ((BlazeBurnerBlockEntityAccessor)this.burner).setActiveFuel(BlazeBurnerBlockEntity.FuelType.NORMAL);
            fuel = BlazeBurnerBlockEntity.FuelType.NORMAL;
        }
        int rate = fuel == BlazeBurnerBlockEntity.FuelType.NORMAL ? BOOST_RATE : SEETHING_BOOST_RATE;
        ((BlazeBurnerBlockEntityAccessor)this.burner).setRemainingBurnTime(this.getBurnTime() + rate);
        this.burner.updateBlockState();
    }

    public void boostCookTime() {
    }
}

