/*
 * Decompiled with CFR 0.152.
 */
package novamachina.novacore.data;

import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import novamachina.novacore.util.StringUtils;
import novamachina.novacore.world.item.ItemDefinition;
import novamachina.novacore.world.level.block.BlockDefinition;

public class AbstractLangGenerator
extends LanguageProvider {
    private final String ITEM_LANG;
    private final String BLOCK_LANG;
    private final String FLUID_LANG;

    public AbstractLangGenerator(PackOutput output, String modId, String locale) {
        super(output, modId, locale);
        this.ITEM_LANG = String.format("item.%s.", modId);
        this.BLOCK_LANG = String.format("block.%s.", modId);
        this.FLUID_LANG = String.format("fluid_type.%s.", modId);
    }

    protected void addTranslations() {
    }

    protected String properNaming(String item) {
        return StringUtils.capitalize(item.replace("_", " "));
    }

    protected void addItemAutoName(String item) {
        this.add(this.ITEM_LANG + item, this.properNaming(item));
    }

    protected void addItemName(ItemDefinition<? extends Item> definition) {
        this.add(this.ITEM_LANG + definition.getId().m_135815_(), definition.getEnglishName());
    }

    protected void addPieceAutoName(String item) {
        this.add(this.ITEM_LANG + item + "_pieces", this.properNaming(item + "_pieces"));
    }

    protected void addFluidName(String fluid, String name) {
        this.add(this.FLUID_LANG + fluid, name);
    }

    protected void addBlockName(BlockDefinition<? extends Block> definition) {
        this.add(this.BLOCK_LANG + definition.getId().m_135815_(), definition.getEnglishName());
    }
}

