/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.network.packet;

import com.nukateam.chassis_core.common.data.enums.ActionType;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.util.helpers.PlayerUtils;
import com.nukateam.ntgl.common.network.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class C2SActionPacket
implements IMessage<C2SActionPacket> {
    ActionType action = null;

    public C2SActionPacket(ActionType action) {
        this.action = action;
    }

    public C2SActionPacket() {
    }

    @Override
    public void encode(C2SActionPacket actionPacket, FriendlyByteBuf buffer) {
        buffer.writeByte(actionPacket.action.getId());
    }

    @Override
    public C2SActionPacket decode(FriendlyByteBuf buffer) {
        ActionType action = ActionType.getById(buffer.readByte());
        return new C2SActionPacket(action);
    }

    @Override
    public void handle(C2SActionPacket message, NetworkEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            if (!PlayerUtils.isWearingChassis((Entity)player)) {
                return;
            }
            WearableChassis armor = (WearableChassis)player.m_20202_();
            switch (message.action) {
                case DISMOUNT: {
                    armor.exitArmor();
                    break;
                }
                case OPEN_GUI: {
                    armor.openGUI((Player)player);
                }
            }
        });
        supplier.setPacketHandled(true);
    }
}

