/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.nukateam.ntgl.common.network.IMessage;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.network.NetworkEvent;

public class C2SMessageReload
implements IMessage<C2SMessageReload> {
    private boolean reload;
    private InteractionHand hand = InteractionHand.MAIN_HAND;

    public C2SMessageReload() {
    }

    public C2SMessageReload(boolean reload, InteractionHand hand) {
        this.reload = reload;
        this.hand = hand;
    }

    @Override
    public void encode(C2SMessageReload message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.reload);
        buffer.m_130068_((Enum)message.hand);
    }

    @Override
    public C2SMessageReload decode(FriendlyByteBuf buffer) {
        return new C2SMessageReload(buffer.readBoolean(), (InteractionHand)buffer.m_130066_(InteractionHand.class));
    }

    @Override
    public void handle(C2SMessageReload message, NetworkEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            if (player != null && !player.m_5833_()) {
                ServerPlayHandler.handleReload(message, player);
            }
        });
        supplier.setPacketHandled(true);
    }

    public boolean isReload() {
        return this.reload;
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

