/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.registry;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.obscuria.tooltips.ObscureTooltips;
import dev.obscuria.tooltips.client.registry.ResourceRegistry;
import dev.obscuria.tooltips.client.registry.TooltipRegistries;
import dev.obscuria.tooltips.client.tooltip.TooltipDefinition;
import dev.obscuria.tooltips.client.tooltip.TooltipLabel;
import dev.obscuria.tooltips.client.tooltip.TooltipStyle;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.tooltip.element.frame.TooltipFrame;
import dev.obscuria.tooltips.client.tooltip.element.icon.TooltipIcon;
import dev.obscuria.tooltips.client.tooltip.element.panel.TooltipPanel;
import dev.obscuria.tooltips.client.tooltip.element.slot.TooltipSlot;
import net.minecraft.resources.ResourceLocation;

public enum ResourceKind {
    PANEL(new Spec<TooltipPanel>("panel", "element/panel", TooltipPanel.DIRECT_CODEC, TooltipRegistries.Resource.TOOLTIP_PANEL)),
    FRAME(new Spec<TooltipFrame>("frame", "element/frame", TooltipFrame.DIRECT_CODEC, TooltipRegistries.Resource.TOOLTIP_FRAME)),
    SLOT(new Spec<TooltipSlot>("slot", "element/slot", TooltipSlot.DIRECT_CODEC, TooltipRegistries.Resource.TOOLTIP_SLOT)),
    ICON(new Spec<TooltipIcon>("icon", "element/icon", TooltipIcon.DIRECT_CODEC, TooltipRegistries.Resource.TOOLTIP_ICON)),
    EFFECT(new Spec<TooltipEffect>("effect", "element/effect", TooltipEffect.DIRECT_CODEC, TooltipRegistries.Resource.TOOLTIP_EFFECT)),
    STYLE(new Spec<TooltipStyle>("style", "style", TooltipStyle.DIRECT_CODEC, TooltipRegistries.Resource.TOOLTIP_STYLE)),
    DEFINITION(new Spec<TooltipDefinition>("definition", "definition", TooltipDefinition.DIRECT_CODEC, TooltipRegistries.Resource.TOOLTIP_DEFINITION)),
    LABEL(new Spec<TooltipLabel>("label", "label", TooltipLabel.DIRECT_CODEC, TooltipRegistries.Resource.TOOLTIP_LABEL));

    public final Spec<?> spec;

    private ResourceKind(Spec<?> spec) {
        this.spec = spec;
    }

    public record Spec<T>(String name, String directory, Codec<T> codec, ResourceRegistry<T> registry) {
        public String resourceDir() {
            return "tooltips/" + this.directory;
        }

        public void onReloadStart() {
            this.registry.onReloadStart();
        }

        public void load(ResourceLocation key, JsonElement element) {
            DataResult result = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
            result.result().ifPresent(it -> this.registry.register(key, it.getFirst()));
            result.error().ifPresent(it -> ObscureTooltips.LOGGER.error("Failed to register {} with key {}: {}", new Object[]{this.name, key, it.message()}));
        }

        public void onReloadEnd() {
            this.registry.onReloadEnd();
            ObscureTooltips.LOGGER.info("Loaded {} resources from {}", (Object)this.registry.total(), (Object)this.resourceDir());
        }
    }
}

