/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.tooltips.client.TooltipHelper;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.config.ARGBProvider;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public record GlintEffect(int segments, boolean clipWaves, boolean clipRings, List<WaveSpecs> waves, List<RingSpecs> rings) implements TooltipEffect
{
    public static final Codec<GlintEffect> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("segments").forGetter(GlintEffect::segments), (App)Codec.BOOL.optionalFieldOf("clip_waves", (Object)true).forGetter(GlintEffect::clipWaves), (App)Codec.BOOL.optionalFieldOf("clip_rings", (Object)true).forGetter(GlintEffect::clipRings), (App)WaveSpecs.CODEC.listOf().fieldOf("waves").forGetter(GlintEffect::waves), (App)RingSpecs.CODEC.listOf().fieldOf("rings").forGetter(GlintEffect::rings)).apply((Applicative)codec, GlintEffect::new));
    private static final float TAU = (float)Math.PI * 2;

    public Codec<GlintEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof GlintEffect);
    }

    @Override
    public void renderBack(TooltipState state, GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280168_().m_85836_();
        float centerX = (float)x + (float)width * 0.5f;
        float centerY = (float)y + (float)height * 0.5f;
        float radius = (float)Math.hypot(width, height) * 0.85f;
        float timer = state.timeInSeconds() * 0.1f;
        TooltipHelper.enableGlowingRenderer();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        if (this.clipWaves) {
            graphics.m_280588_(x - 3, y - 3, x + width + 3, y + height + 3);
        }
        this.renderWaves(buffer, matrix, centerX, centerY, width, height, radius, timer);
        if (this.clipWaves) {
            graphics.m_280618_();
        }
        if (this.clipRings) {
            graphics.m_280588_(x - 3, y - 3, x + width + 3, y + height + 3);
        }
        this.renderRings(buffer, matrix, centerX, centerY, radius, timer);
        if (this.clipRings) {
            graphics.m_280618_();
        }
        TooltipHelper.disableGlowingRenderer();
        graphics.m_280168_().m_85849_();
    }

    private void renderWaves(BufferBuilder buffer, Matrix4f matrix, float x, float y, int width, int height, float radius, float timer) {
        if (this.waves.isEmpty()) {
            return;
        }
        float aspect = (float)height / (float)Math.max(1, width);
        for (WaveSpecs specs : this.waves) {
            ARGB color = specs.color.get();
            float baseRadius = radius * specs.position();
            float thickness = radius * specs.thickness() * 0.5f;
            float progress = timer * ((float)Math.PI * 2) * specs.flowSpeed();
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            for (int i = 0; i <= this.segments; ++i) {
                float segment = (float)i / (float)this.segments;
                float angle = segment * ((float)Math.PI * 2) + progress;
                float sin = (float)Math.sin(angle);
                float cos = (float)Math.cos(angle);
                float swirl = this.computeSwirl(angle, progress, specs.flowOffset()) * radius;
                float ringRadius = baseRadius + swirl;
                float innerR = ringRadius + thickness * specs.innerBias();
                float outerR = ringRadius + thickness * specs.outerBias();
                float ix = x + cos * innerR;
                float iy = y + sin * innerR * aspect;
                float ox = x + cos * outerR;
                float oy = y + sin * outerR * aspect;
                float intensity = this.computeIntensity(sin, angle, progress, specs.intensityOffset(), specs.verticalFade());
                float innerA = color.alpha() * intensity * specs.innerAlpha();
                float outerA = color.alpha() * intensity * specs.outerAlpha();
                buffer.m_252986_(matrix, ox, oy, 0.0f).m_85950_(color.red(), color.green(), color.blue(), outerA).m_5752_();
                buffer.m_252986_(matrix, ix, iy, 0.0f).m_85950_(color.red(), color.green(), color.blue(), innerA).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        }
    }

    private void renderRings(BufferBuilder buffer, Matrix4f matrix, float x, float y, float radius, float timer) {
        if (this.rings.isEmpty()) {
            return;
        }
        for (int ringIndex = 0; ringIndex < this.rings.size(); ++ringIndex) {
            RingSpecs specs = this.rings.get(ringIndex);
            ARGB color = specs.color.get();
            float baseRadius = radius * specs.radius();
            float thickness = radius * specs.thickness();
            float progress = timer * ((float)Math.PI * 2) * specs.spinSpeed();
            float arcSpan = 4.3982296f;
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            for (int i = 0; i <= this.segments; ++i) {
                float segment = (float)i / (float)this.segments;
                float angle = (segment - 0.5f) * 4.3982296f + progress + specs.arcOffset();
                float sin = (float)Math.sin(angle);
                float cos = (float)Math.cos(angle);
                float wobble = this.computeWobble(segment, timer, ringIndex);
                float rBase = baseRadius + wobble * radius * 0.18f;
                float innerR = rBase - thickness * 0.5f;
                float outerR = rBase + thickness * 0.5f;
                float ix = x + cos * innerR;
                float iy = y + sin * innerR;
                float ox = x + cos * outerR;
                float oy = y + sin * outerR;
                float intensity = this.computeIntensity(segment, timer, ringIndex);
                float edgeA = color.alpha() * intensity * 0.4f;
                float coreA = color.alpha() * intensity * 0.9f;
                buffer.m_252986_(matrix, ox, oy, 0.0f).m_85950_(color.red(), color.green(), color.blue(), edgeA).m_5752_();
                buffer.m_252986_(matrix, ix, iy, 0.0f).m_85950_(color.red(), color.green(), color.blue(), coreA).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        }
    }

    private float computeSwirl(float angle, float progress, float offset) {
        float swirl1 = 0.12f * (float)Math.sin(angle * 3.0f + progress * 2.1f + offset * 0.7f);
        float swirl2 = 0.07f * (float)Math.sin(angle * 7.0f - progress * 1.4f);
        return swirl1 + swirl2;
    }

    private float computeIntensity(float sin, float angle, float progress, float offset, boolean verticalFade) {
        float band = 0.5f + 0.5f * (float)Math.sin(angle * 2.0f - progress * 1.3f + offset);
        if (verticalFade) {
            float vertical = Math.max(0.0f, sin * 0.8f + 0.2f);
            return vertical * (0.4f + 0.6f * band);
        }
        float hMask = (float)Math.pow(Math.abs(sin), 1.4f);
        return hMask * (0.35f + 0.65f * band);
    }

    private float computeWobble(float segment, float timer, int ringIndex) {
        return 0.08f * (float)Math.sin(segment * 6.0f + timer * ((float)Math.PI * 2) * 2.0f + (float)ringIndex * 1.7f);
    }

    private float computeIntensity(float segment, float timer, int ringIndex) {
        float arcMask = (float)Math.sin((double)segment * Math.PI);
        float pulse = 0.6f + 0.4f * (float)Math.sin(timer * ((float)Math.PI * 2) * 3.0f + segment * 5.0f + (float)ringIndex * 1.3f);
        return arcMask * pulse;
    }

    public record WaveSpecs(ARGBProvider color, float position, float thickness, float innerAlpha, float innerBias, float outerAlpha, float outerBias, float flowSpeed, float flowOffset, float intensityOffset, boolean verticalFade) {
        public static final Codec<WaveSpecs> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ARGBProvider.CODEC.fieldOf("color").forGetter(WaveSpecs::color), (App)Codec.FLOAT.fieldOf("position").forGetter(WaveSpecs::position), (App)Codec.FLOAT.fieldOf("thickness").forGetter(WaveSpecs::thickness), (App)Codec.FLOAT.fieldOf("inner_alpha").forGetter(WaveSpecs::innerAlpha), (App)Codec.FLOAT.fieldOf("inner_bias").forGetter(WaveSpecs::innerBias), (App)Codec.FLOAT.fieldOf("outer_alpha").forGetter(WaveSpecs::outerAlpha), (App)Codec.FLOAT.fieldOf("outer_bias").forGetter(WaveSpecs::outerBias), (App)Codec.FLOAT.fieldOf("flow_speed").forGetter(WaveSpecs::flowSpeed), (App)Codec.FLOAT.fieldOf("flow_offset").forGetter(WaveSpecs::flowOffset), (App)Codec.FLOAT.fieldOf("intensity_offset").forGetter(WaveSpecs::intensityOffset), (App)Codec.BOOL.fieldOf("vertical_fade").forGetter(WaveSpecs::verticalFade)).apply((Applicative)codec, WaveSpecs::new));
    }

    public record RingSpecs(ARGBProvider color, float spinSpeed, float radius, float thickness, float arcOffset) {
        public static final Codec<RingSpecs> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ARGBProvider.CODEC.fieldOf("color").forGetter(RingSpecs::color), (App)Codec.FLOAT.fieldOf("spin_speed").forGetter(RingSpecs::spinSpeed), (App)Codec.FLOAT.fieldOf("radius").forGetter(RingSpecs::radius), (App)Codec.FLOAT.fieldOf("thickness").forGetter(RingSpecs::thickness), (App)Codec.FLOAT.fieldOf("arc_offset").forGetter(RingSpecs::arcOffset)).apply((Applicative)codec, RingSpecs::new));
    }
}

