/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin.plugin;

import com.petrolpark.compat.CompatMods;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class PetrolparkMixinPlugin
implements IMixinConfigPlugin {
    private int mixinPackagePathLength = 1;
    private final Map<String, Supplier<Boolean>> shouldLoad = new HashMap<String, Supplier<Boolean>>();

    protected String getMixinPackage() {
        return "com.petrolpark.mixin";
    }

    private int getMixinPackagePathLength() {
        if (this.mixinPackagePathLength == -1) {
            this.mixinPackagePathLength = this.getMixinPackage().split(".").length;
        }
        return this.mixinPackagePathLength;
    }

    public void onLoad(String mixinPackage) {
        this.requireMultipleMods("client.JustEnoughItemsClientMixin", CompatMods.JEI, CompatMods.CREATE);
    }

    protected void requireMultipleMods(String mixinClassName, CompatMods ... requiredMods) {
        String className = this.getMixinPackage() + ".compat." + requiredMods[0].id + "." + mixinClassName;
        this.shouldLoad.put(className, () -> {
            for (CompatMods mod : requiredMods) {
                if (mod.isLoading()) continue;
                return false;
            }
            return true;
        });
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String[] mixinPath = mixinClassName.split(".");
        if (mixinPath.length >= this.getMixinPackagePathLength() && mixinPath[this.getMixinPackagePathLength()].equals("compat")) {
            return CompatMods.isLoading(mixinPath[this.getMixinPackagePathLength() + 1]);
        }
        Supplier<Boolean> predicate = this.shouldLoad.get(mixinClassName);
        if (predicate == null) {
            return true;
        }
        return predicate.get();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return Collections.emptyList();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

