/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe;

import com.petrolpark.recipe.advancedprocessing.firsttimelucky.IFirstTimeLuckyRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RecipeHelper {
    private static final Random r = new Random();

    public static List<ItemStack> rollResults(ProcessingRecipe<?> recipe, int multiplier) {
        return RecipeHelper.rollResults(recipe, null, multiplier);
    }

    public static List<ItemStack> rollResults(ProcessingRecipe<?> recipe, Player player, int multiplier) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        if (recipe == null) {
            return results;
        }
        if (recipe instanceof IFirstTimeLuckyRecipe) {
            IFirstTimeLuckyRecipe luckyRecipe = (IFirstTimeLuckyRecipe)recipe;
            if (player != null && multiplier > 0) {
                results.addAll(luckyRecipe.rollLuckyResults(player));
                --multiplier;
            }
        }
        if (multiplier <= 0) {
            return results;
        }
        for (ProcessingOutput output : recipe.getRollableResults()) {
            float expectedCount = (float)multiplier * output.getChance() * (float)output.getStack().m_41613_();
            int count = (int)expectedCount;
            if (r.nextFloat() < expectedCount - (float)count) {
                ++count;
            }
            int stackSize = output.getStack().m_41741_();
            for (int i = 0; i < count / stackSize; ++i) {
                results.add(output.getStack().m_255036_(stackSize));
            }
            results.add(output.getStack().m_255036_(count % stackSize));
        }
        return results;
    }
}

