/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe.condition;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.petrolpark.Petrolpark;
import java.util.List;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigBooleanCondition
implements ICondition {
    public static final ResourceLocation ID = Petrolpark.asResource("config_boolean");
    public static final Serializer SERIALIZER = new Serializer();
    private final String modId;
    private final ForgeConfigSpec.BooleanValue value;

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((IConditionSerializer)SERIALIZER);
        }
    }

    public ConfigBooleanCondition(String modId, ForgeConfigSpec.BooleanValue value) {
        this.modId = modId;
        this.value = value;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        return this.value != null && (Boolean)this.value.get() != false;
    }

    public static class Serializer
    implements IConditionSerializer<ConfigBooleanCondition> {
        public void write(JsonObject json, ConfigBooleanCondition value) {
            json.addProperty("value", Joiner.on((String)".").join(value.value.getPath().iterator()));
            json.addProperty("mod", value.modId);
        }

        public ConfigBooleanCondition read(JsonObject json) {
            if (!json.has("value")) {
                throw new JsonSyntaxException("Must specify a config boolean");
            }
            if (!json.has("mod")) {
                throw new JsonSyntaxException("Must specify a mod ID");
            }
            String path = GsonHelper.m_13906_((JsonObject)json, (String)"value");
            String modId = GsonHelper.m_13906_((JsonObject)json, (String)"mod");
            ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)ConfigHelper.findForgeConfigSpecFor((ModConfig.Type)ModConfig.Type.COMMON, (String)modId).getValues().get((List)ImmutableList.copyOf((Iterable)Splitter.on((String)".").split((CharSequence)path)));
            if (!(configValue instanceof ForgeConfigSpec.BooleanValue)) {
                throw new JsonSyntaxException("The config must be a boolean type.");
            }
            ForgeConfigSpec.BooleanValue booleanValue = (ForgeConfigSpec.BooleanValue)configValue;
            return new ConfigBooleanCondition(modId, booleanValue);
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

