/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.planetary_gearset;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.petrolsparts.PetrolsPartsPartialModels;
import com.petrolpark.petrolsparts.content.planetary_gearset.PlanetaryGearsetBlockEntity;
import com.petrolpark.util.KineticsHelper;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3fc;

public class PlanetaryGearsetRenderer
extends KineticBlockEntityRenderer<PlanetaryGearsetBlockEntity> {
    public PlanetaryGearsetRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PlanetaryGearsetBlockEntity planetaryGearsetBlockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = this.getRenderedBlockState((KineticBlockEntity)planetaryGearsetBlockEntity);
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        VertexConsumer vbSolid = buffer.m_6299_(RenderType.m_110451_());
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)planetaryGearsetBlockEntity.m_58904_());
        float offset1 = (float)Math.PI * PlanetaryGearsetRenderer.getRotationOffsetForPosition((KineticBlockEntity)planetaryGearsetBlockEntity, (BlockPos)planetaryGearsetBlockEntity.m_58899_(), (Direction.Axis)axis) / 180.0f;
        float offset2 = (float)Math.PI * BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)planetaryGearsetBlockEntity.m_58899_()) / 180.0f;
        float angle = (time * planetaryGearsetBlockEntity.getSpeed() * 3.0f / 10.0f + offset1) % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer ringGear = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.PG_RING_GEAR, (BlockState)state, (Direction)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis((Direction.Axis)axis));
        PlanetaryGearsetRenderer.kineticRotationTransform((SuperByteBuffer)ringGear, (KineticBlockEntity)planetaryGearsetBlockEntity, (Direction.Axis)axis, (float)(angle + offset1), (int)light);
        ringGear.renderInto(ms, vbSolid);
        SuperByteBuffer sunGear = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.PG_SUN_GEAR, (BlockState)state, (Direction)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis((Direction.Axis)axis));
        PlanetaryGearsetRenderer.kineticRotationTransform((SuperByteBuffer)sunGear, (KineticBlockEntity)planetaryGearsetBlockEntity, (Direction.Axis)axis, (float)(-2.0f * angle + offset2), (int)light);
        sunGear.renderInto(ms, vbSolid);
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == axis) continue;
            SuperByteBuffer planetGear = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.PG_PLANET_GEAR, (BlockState)state, (Direction)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), () -> KineticsHelper.rotateToAxis((Direction.Axis)axis));
            planetGear.translate((Vector3fc)direction.m_253071_().mul(0.390625f));
            PlanetaryGearsetRenderer.kineticRotationTransform((SuperByteBuffer)planetGear, (KineticBlockEntity)planetaryGearsetBlockEntity, (Direction.Axis)axis, (float)(2.0f * angle + offset2), (int)light);
            planetGear.renderInto(ms, vbSolid);
        }
    }
}

