/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.GasFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.ModBlocks;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.capabilities.ModCapabilities;
import de.maxhenkel.pipez.utils.GasUtils;
import de.maxhenkel.pipez.utils.MekanismUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;

public class GasPipeType
extends PipeType<Chemical> {
    public static final GasPipeType INSTANCE = new GasPipeType();

    @Override
    public String getKey() {
        return "Gas";
    }

    @Override
    public Capability<?> getCapability() {
        return ModCapabilities.GAS_HANDLER_CAPABILITY;
    }

    @Override
    public Capability<?>[] getCapabilities() {
        if (!MekanismUtils.isMekanismInstalled()) {
            return new Capability[0];
        }
        return GasUtils.getChemicalCapabilities();
    }

    @Override
    public Filter<Chemical> createFilter() {
        return new GasFilter();
    }

    @Override
    public String getTranslationKey() {
        return "tooltip.pipez.gas";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ModBlocks.GAS_PIPE.get());
    }

    @Override
    public Component getTransferText(@Nullable Upgrade upgrade) {
        return Component.m_237110_((String)"tooltip.pipez.rate.gas", (Object[])new Object[]{this.getRate(upgrade)});
    }

    @Override
    public void tick(PipeLogicTileEntity tileEntity) {
        if (!MekanismUtils.isMekanismInstalled()) {
            return;
        }
        for (Direction side : Direction.values()) {
            PipeTileEntity.Connection extractingConnection;
            if (!tileEntity.isExtracting(side) || !tileEntity.shouldWork(side, this) || (extractingConnection = tileEntity.getExtractingConnection(side)) == null) continue;
            for (ChemicalType type : ChemicalType.values()) {
                IChemicalHandler gasHandler = (IChemicalHandler)extractingConnection.getChemicalHandler(type, tileEntity.m_58904_()).orElse(null);
                if (gasHandler == null) continue;
                this.tickHandler(tileEntity, gasHandler, side, type);
            }
        }
    }

    private void tickHandler(PipeLogicTileEntity tileEntity, IChemicalHandler gasHandler, Direction side, ChemicalType type) {
        List<PipeTileEntity.Connection> connections = tileEntity.getSortedConnections(side, this);
        if (tileEntity.getDistribution(side, this).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
            this.insertEqually(tileEntity, side, connections, gasHandler, type);
        } else {
            this.insertOrdered(tileEntity, side, connections, gasHandler, type);
        }
    }

    protected void insertEqually(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IChemicalHandler gasHandler, ChemicalType type) {
        long completeAmount;
        if (connections.isEmpty()) {
            return;
        }
        long mbToTransfer = completeAmount = (long)this.getRate(tileEntity, side);
        boolean[] connectionsFull = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, this) % connections.size();
        while (mbToTransfer > 0L && this.hasNotInserted(connectionsFull)) {
            PipeTileEntity.Connection connection = connections.get(p);
            IChemicalHandler destination = (IChemicalHandler)connection.getChemicalHandler(type, tileEntity.m_58904_()).orElse(null);
            boolean hasInserted = false;
            if (destination != null && !connectionsFull[p]) {
                for (int j = 0; j < gasHandler.getTanks(); ++j) {
                    ChemicalStack stack;
                    ChemicalStack gasInTank = gasHandler.getChemicalInTank(j);
                    ChemicalStack simulatedExtract = gasHandler.extractChemical(GasUtils.createChemicalStack(gasInTank.getType(), Math.min(Math.max(completeAmount / (long)GasPipeType.getConnectionsNotFullCount(connectionsFull), 1L), mbToTransfer)), Action.SIMULATE);
                    if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST) || (stack = this.transfer(gasHandler, destination, simulatedExtract)).getAmount() <= 0L) continue;
                    mbToTransfer -= stack.getAmount();
                    hasInserted = true;
                    break;
                }
            }
            if (!hasInserted) {
                connectionsFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, this, p);
    }

    protected void insertOrdered(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IChemicalHandler gasHandler, ChemicalType type) {
        long mbToTransfer = this.getRate(tileEntity, side);
        block0: for (PipeTileEntity.Connection connection : connections) {
            IChemicalHandler destination = (IChemicalHandler)connection.getChemicalHandler(type, tileEntity.m_58904_()).orElse(null);
            if (destination == null) continue;
            for (int i = 0; i < gasHandler.getTanks(); ++i) {
                if (mbToTransfer <= 0L) break block0;
                ChemicalStack gasInTank = gasHandler.getChemicalInTank(i);
                ChemicalStack simulatedExtract = gasHandler.extractChemical(GasUtils.createChemicalStack(gasInTank.getType(), mbToTransfer), Action.SIMULATE);
                if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                ChemicalStack stack = this.transfer(gasHandler, destination, simulatedExtract);
                mbToTransfer -= stack.getAmount();
            }
        }
    }

    private ChemicalStack transfer(IChemicalHandler source, IChemicalHandler destination, ChemicalStack transfer) {
        ChemicalStack extracted = source.extractChemical(transfer, Action.SIMULATE);
        ChemicalStack gasStack = destination.insertChemical(extracted, Action.EXECUTE);
        return source.extractChemical(GasUtils.createChemicalStack(extracted.getType(), extracted.getAmount() - gasStack.getAmount()), Action.EXECUTE);
    }

    private boolean canInsert(PipeTileEntity.Connection connection, ChemicalStack stack, List<Filter<?>> filters) {
        for (Filter filter2 : filters.stream().map(filter -> filter).filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(filter2, stack)) continue;
            return false;
        }
        List collect = filters.stream().map(filter -> filter).filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter3 : collect) {
            if (!this.matches(filter3, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Filter<Chemical> filter, ChemicalStack stack) {
        return filter.getTag() == null || filter.getTag().contains(stack.getType());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRate(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.gasPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

