/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blockentity;

import com.tiviacz.pizzadelight.blockentity.BaseBlockEntity;
import com.tiviacz.pizzadelight.config.PizzaDelightConfig;
import com.tiviacz.pizzadelight.container.PizzaStationMenu;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.tags.ModTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class PizzaStationBlockEntity
extends BaseBlockEntity
implements MenuProvider {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<ItemStackHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);

    public PizzaStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.PIZZA_STATION.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new PizzaStationMenu(id, playerInventory, this);
    }

    public void openGUI(Player player, MenuProvider containerSupplier, BlockPos pos) {
        if (!player.m_9236_().f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerSupplier, (BlockPos)pos);
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(12){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (stack.m_220173_().m_203373_(new ResourceLocation("some_assembly_required", "sandwich"))) {
                    return false;
                }
                if (slot == 0) {
                    return false;
                }
                if (slot == 1) {
                    return stack.m_150930_((Item)ModItems.RAW_PIZZA.get());
                }
                if (slot == 2) {
                    return stack.m_204117_(ModTags.SAUCE) || stack.m_41720_() instanceof PotionItem;
                }
                if (((Boolean)PizzaDelightConfig.SERVER.allowOnlyRecommendedIngredients.get()).booleanValue()) {
                    return stack.m_204117_(ModTags.INGREDIENTS);
                }
                return stack.m_41614_() || stack.m_204117_(ModTags.INGREDIENTS);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                PizzaStationBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

