/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blocks;

import com.tiviacz.pizzadelight.blockentity.BasinBlockEntity;
import com.tiviacz.pizzadelight.blockentity.content.BasinContent;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.tags.ModTags;
import com.tiviacz.pizzadelight.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasinBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = BasinBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public BasinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasinBlockEntity) {
            BasinBlockEntity blockEntity2 = (BasinBlockEntity)blockEntity;
            if (stack.m_150930_(Items.f_42455_) && blockEntity2.getBasinContent() == BasinContent.AIR) {
                return blockEntity2.addMilk(level, player, handIn);
            }
            if (stack.m_204117_(ModTags.FERMENTING_ITEMS_TAG) && blockEntity2.getBasinContent() == BasinContent.MILK) {
                return blockEntity2.useFermentingItem(stack, level, player);
            }
            if (stack.m_150930_(Items.f_42446_) && blockEntity2.getBasinContent() == BasinContent.MILK) {
                return blockEntity2.removeMilk(stack, level, player);
            }
            if (level.f_46443_) {
                if (blockEntity2.removeCheese(level, player).m_19077_()) {
                    return InteractionResult.SUCCESS;
                }
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                    return InteractionResult.CONSUME;
                }
            }
            return blockEntity2.removeCheese(level, player);
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof BasinBlockEntity) {
                BasinBlockEntity blockEntity2 = (BasinBlockEntity)blockEntity;
                if (blockEntity2.getBasinContent() == BasinContent.CHEESE) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((Item)ModItems.CHEESE_BLOCK.get()).m_7968_());
                }
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasinBlockEntity) {
            BasinBlockEntity blockEntity2 = (BasinBlockEntity)blockEntity;
            return blockEntity2.getComparatorOutput();
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BasinBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return Utils.getTicker(blockEntityType, (BlockEntityType)ModBlockEntityTypes.BASIN.get(), BasinBlockEntity::tick);
    }
}

