/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.pizzadelight.PizzaDelight;
import com.tiviacz.pizzadelight.blockentity.PizzaStationBlockEntity;
import com.tiviacz.pizzadelight.client.tooltip.IngredientsTooltip;
import com.tiviacz.pizzadelight.container.PizzaStationMenu;
import com.tiviacz.pizzadelight.network.ServerboundRenamePizzaPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenPizzaStation
extends AbstractContainerScreen<PizzaStationMenu>
implements MenuAccess<PizzaStationMenu>,
ContainerListener {
    public static final ResourceLocation SCREEN_PIZZA_STATION = new ResourceLocation("pizzadelight", "textures/gui/pizza_station.png");
    private static final ResourceLocation EMPTY_SLOT_SAUCE = new ResourceLocation("pizzadelight", "item/empty_slot_sauce");
    private static final ResourceLocation EMPTY_SLOT_POTION = new ResourceLocation("pizzadelight", "item/empty_slot_potion");
    private static final ResourceLocation EMPTY_SLOT_RAW_PIZZA = new ResourceLocation("pizzadelight", "item/empty_slot_raw_pizza");
    public static final List<ResourceLocation> SAUCES = List.of(EMPTY_SLOT_SAUCE, EMPTY_SLOT_POTION);
    private static final List<ResourceLocation> DOUGH = List.of(EMPTY_SLOT_RAW_PIZZA);
    private final PizzaStationBlockEntity blockEntity;
    private EditBox name;
    public final CyclingSlotBackground sauceIcon = new CyclingSlotBackground(2);
    private final CyclingSlotBackground doughIcon = new CyclingSlotBackground(1);

    public ScreenPizzaStation(PizzaStationMenu menu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)menu, inv, titleIn);
        this.blockEntity = menu.blockEntity;
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97728_ = 55;
        this.f_97729_ = 6;
        this.f_97726_ = 176;
        this.f_97727_ = 196;
        this.f_97731_ += 31;
    }

    public void m_181908_() {
        super.m_181908_();
        this.name.m_94120_();
        this.sauceIcon.m_266287_(SAUCES);
        this.doughIcon.m_266287_(DOUGH);
    }

    public void m_7856_() {
        super.m_7856_();
        this.subInit();
        ((PizzaStationMenu)this.f_97732_).m_38893_(this);
    }

    protected void subInit() {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.name = new EditBox(this.f_96547_, i + 57, j + 24, 98, 12, this.blockEntity.m_5446_());
        this.name.m_94190_(true);
        this.name.m_94202_(-1);
        this.name.m_94205_(-1);
        this.name.m_94182_(false);
        this.name.m_94199_(50);
        this.name.m_94151_(this::onNameChanged);
        this.name.m_94144_("");
        this.m_7787_((GuiEventListener)this.name);
        this.name.m_94186_(false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableBlend();
        this.renderFg(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        if (this.getGuiLeft() + 116 <= pX && pX <= this.getGuiLeft() + 22 + 116 && this.getGuiTop() + 66 <= pY && pY <= this.getGuiTop() + 15 + 66) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.m_237115_((String)"information.pizzadelight.view_recommended_ingredients"));
            pGuiGraphics.m_280677_(this.f_96547_, components, Optional.of(new IngredientsTooltip()), pX, pY);
        }
    }

    public void renderFg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.name.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(SCREEN_PIZZA_STATION, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.sauceIcon.m_266270_(this.f_97732_, guiGraphics, partialTicks, this.f_97735_, this.f_97736_);
        this.doughIcon.m_266270_(this.f_97732_, guiGraphics, partialTicks, this.f_97735_, this.f_97736_);
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.name.m_94155_();
        this.m_6575_(pMinecraft, pWidth, pHeight);
        this.name.m_94144_(s);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.name.m_7933_(pKeyCode, pScanCode, pModifiers) || this.name.m_94204_() || super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private void onNameChanged(String name) {
        if (!name.isEmpty()) {
            String s = name;
            Slot slot = ((PizzaStationMenu)this.f_97732_).m_38853_(0);
            if (slot != null && slot.m_6657_() && !slot.m_7993_().m_41788_() && name.equals(slot.m_7993_().m_41786_().getString())) {
                s = "";
            }
            ((PizzaStationMenu)this.f_97732_).setItemName(s);
            PizzaDelight.NETWORK.sendToServer((Object)new ServerboundRenamePizzaPacket(s));
        }
    }

    public void m_7861_() {
        super.m_7861_();
        ((PizzaStationMenu)this.f_97732_).m_38943_(this);
    }

    public void m_7934_(AbstractContainerMenu pContainerToSend, int pSlotInd, ItemStack pStack) {
        if (pSlotInd == 0) {
            this.name.m_94144_(pStack.m_41619_() ? "" : pStack.m_41786_().getString());
            this.name.m_94186_(!pStack.m_41619_());
        }
    }

    public void m_142153_(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
        this.m_7934_(pContainerMenu, 0, pContainerMenu.m_38853_(0).m_7993_());
    }
}

