/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.init.ModItems;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class PizzaWithoutLevelRenderer
extends BlockEntityWithoutLevelRenderer {
    private final Supplier<PizzaBlockEntity> pizza;

    public PizzaWithoutLevelRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet set, Supplier<PizzaBlockEntity> blockEntity) {
        super(dispatcher, set);
        this.pizza = blockEntity;
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState pState = stack.m_41720_() == ModItems.RAW_PIZZA.get() ? ((Block)ModBlocks.RAW_PIZZA.get()).m_49966_() : ((Block)ModBlocks.PIZZA.get()).m_49966_();
        RenderShape rendershape = pState.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            BakedModel bakedmodel = this.getBlockModel(pState);
            for (RenderType rt : bakedmodel.getRenderTypes(pState, RandomSource.m_216335_((long)42L), this.getModelData(stack))) {
                this.renderModel(stack, poseStack.m_85850_(), buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), pState, bakedmodel, combinedLight, combinedOverlay, this.getModelData(stack), rt);
            }
        }
    }

    public void renderModel(ItemStack stack, PoseStack.Pose pPose, VertexConsumer pConsumer, @Nullable BlockState pState, BakedModel pModel, int pPackedLight, int pPackedOverlay, ModelData modelData, RenderType renderType) {
        RandomSource randomsource = RandomSource.m_216327_();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            PizzaWithoutLevelRenderer.renderQuadList(stack, pPose, pConsumer, pModel.getQuads(pState, direction, randomsource, modelData, renderType), pPackedLight, pPackedOverlay);
        }
        randomsource.m_188584_(42L);
        PizzaWithoutLevelRenderer.renderQuadList(stack, pPose, pConsumer, pModel.getQuads(pState, null, randomsource, modelData, renderType), pPackedLight, pPackedOverlay);
    }

    private static void renderQuadList(ItemStack stack, PoseStack.Pose pPose, VertexConsumer pConsumer, List<BakedQuad> pQuads, int pPackedLight, int pPackedOverlay) {
        for (BakedQuad bakedquad : pQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.m_111304_()) {
                int i = Minecraft.m_91087_().getItemColors().m_92676_(stack, bakedquad.m_111305_());
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                f = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
                f1 = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
                f2 = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            pConsumer.m_85987_(pPose, bakedquad, f, f1, f2, pPackedLight, pPackedOverlay);
        }
    }

    public BakedModel getBlockModel(BlockState pState) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(pState);
    }

    public ModelData getModelData(ItemStack stack) {
        return stack.m_41782_() ? this.pizza.get().getItemStackModelData(stack) : ModelData.EMPTY;
    }
}

