/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.SetableSupplier;
import dev.kosmx.playerAnim.impl.Helper;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import dev.kosmx.playerAnim.impl.animation.IBendHelper;
import java.util.function.Function;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class BipedEntityModelMixin<T extends LivingEntity>
extends AgeableListModel<T>
implements IMutableModel {
    @Final
    @Shadow
    public ModelPart f_102811_;
    @Final
    @Shadow
    public ModelPart f_102812_;
    @Unique
    private SetableSupplier<AnimationProcessor> animation = new SetableSupplier();
    @Final
    @Shadow
    public ModelPart f_102810_;
    @Shadow
    @Final
    public ModelPart f_102808_;
    @Shadow
    @Final
    public ModelPart f_102809_;

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;Ljava/util/function/Function;)V"}, at={@At(value="RETURN")})
    private void initBend(ModelPart modelPart, Function<ResourceLocation, RenderType> function, CallbackInfo ci) {
        IBendHelper.INSTANCE.initBend(modelPart.m_171324_("body"), Direction.DOWN);
        IBendHelper.INSTANCE.initBend(modelPart.m_171324_("right_arm"), Direction.UP);
        IBendHelper.INSTANCE.initBend(modelPart.m_171324_("left_arm"), Direction.UP);
        IBendHelper.INSTANCE.initBend(modelPart.m_171324_("right_leg"), Direction.UP);
        IBendHelper.INSTANCE.initBend(modelPart.m_171324_("left_leg"), Direction.UP);
        ((IUpperPartHelper)this.f_102811_).setUpperPart(true);
        ((IUpperPartHelper)this.f_102812_).setUpperPart(true);
        ((IUpperPartHelper)this.f_102808_).setUpperPart(true);
        ((IUpperPartHelper)this.f_102809_).setUpperPart(true);
    }

    @Override
    public void setEmoteSupplier(SetableSupplier<AnimationProcessor> emoteSupplier) {
        this.animation = emoteSupplier;
    }

    @Inject(method={"copyPropertiesTo"}, at={@At(value="RETURN")})
    private void copyMutatedAttributes(HumanoidModel<T> bipedEntityModel, CallbackInfo ci) {
        if (this.animation != null) {
            ((IMutableModel)bipedEntityModel).setEmoteSupplier(this.animation);
        }
    }

    @Intrinsic(displace=true)
    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (Helper.isBendEnabled() && this.animation.get() != null && this.animation.get().isActive()) {
            this.m_5607_().forEach(part -> {
                if (!((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            this.m_5608_().forEach(part -> {
                if (!((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            SetableSupplier<AnimationProcessor> emoteSupplier = this.animation;
            matrices.m_85836_();
            IBendHelper.rotateMatrixStack(matrices, emoteSupplier.get().getBend("body"));
            this.m_5607_().forEach(part -> {
                if (((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            this.m_5608_().forEach(part -> {
                if (((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            matrices.m_85849_();
        } else {
            super.m_7695_(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    @Override
    public SetableSupplier<AnimationProcessor> getEmoteSupplier() {
        return this.animation;
    }
}

