/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.rechiseled.screen.BlockCapture;
import com.supermartijn642.rechiseled.screen.BlockCaptureLevel;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ScreenBlockRenderer {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static BlockCaptureLevel fakeLevel;

    public static void drawBlock(PoseStack poseStack, BlockCapture capture, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AABB bounds = capture.getBounds();
        double span = Math.sqrt(bounds.m_82362_() * bounds.m_82362_() + bounds.m_82376_() * bounds.m_82376_() + bounds.m_82385_() * bounds.m_82385_());
        scale /= span;
        if (fakeLevel == null) {
            fakeLevel = new BlockCaptureLevel();
        }
        fakeLevel.setCapture(capture);
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, 350.0);
        poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(pitch / 180.0f * (float)Math.PI, 1.0f, 0.0f, 0.0f));
        poseStack.m_252781_(new Quaternionf().setAngleAxis(yaw / 180.0f * (float)Math.PI, 0.0f, 1.0f, 0.0f));
        if (doShading) {
            Lighting.m_252756_((Matrix4f)new Matrix4f().rotateX(1.0471976f).rotateY(1.5707964f));
        }
        MultiBufferSource.BufferSource renderTypeBuffer = RenderUtils.getMainBufferSource();
        for (Map.Entry<BlockPos, BlockState> entry : capture.getBlocks()) {
            ScreenBlockRenderer.renderBlock(entry.getKey(), entry.getValue(), poseStack, (MultiBufferSource)renderTypeBuffer);
        }
        renderTypeBuffer.m_109911_();
        RenderSystem.enableDepthTest();
        if (doShading) {
            Lighting.m_84930_();
        }
        poseStack.m_85849_();
        fakeLevel.setCapture(null);
    }

    private static void renderBlock(BlockPos pos, BlockState state, PoseStack poseStack, MultiBufferSource renderTypeBuffer) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_() - 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() - 0.5);
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
        ModelData modelData = model.getModelData((BlockAndTintGetter)fakeLevel, pos, state, ModelData.EMPTY);
        RANDOM.m_188584_(42L);
        ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, RANDOM, modelData);
        for (RenderType renderType : renderTypes) {
            RenderType itemRenderType = renderType == RenderType.m_110466_() ? Sheets.m_110792_() : Sheets.m_110790_();
            ScreenBlockRenderer.renderModel(model, state, poseStack, renderTypeBuffer.m_6299_(itemRenderType), modelData, renderType);
        }
        poseStack.m_85849_();
    }

    private static void renderModel(BakedModel modelIn, BlockState state, PoseStack matrixStackIn, VertexConsumer bufferIn, ModelData modelData, RenderType renderType) {
        for (Direction direction : Direction.values()) {
            RANDOM.m_188584_(42L);
            ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, direction, RANDOM, modelData, renderType));
        }
        RANDOM.m_188584_(42L);
        ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, null, RANDOM, modelData, renderType));
    }

    private static void renderQuads(PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn) {
        PoseStack.Pose matrix = matrixStackIn.m_85850_();
        for (BakedQuad bakedquad : quadsIn) {
            bufferIn.putBulkData(matrix, bakedquad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, false);
        }
    }
}

