/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.preview;

import com.google.common.collect.ImmutableList;
import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.FluidCraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ItemCraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.preview.CraftingPreviewInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CraftingPreviewElementFactory {
    public List<ICraftingPreviewElement> getElements(CraftingPreviewInfo info) {
        ICraftingPreviewElement previewStack;
        int hash;
        LinkedHashMap<Integer, ItemCraftingPreviewElement> map = new LinkedHashMap<Integer, ItemCraftingPreviewElement>();
        LinkedHashMap<Integer, FluidCraftingPreviewElement> mapFluids = new LinkedHashMap<Integer, FluidCraftingPreviewElement>();
        for (StackListEntry<ItemStack> stackListEntry : info.getMissing().getStacks()) {
            hash = API.instance().getItemStackHashCode(stackListEntry.getStack());
            previewStack = map.computeIfAbsent(hash, key -> new ItemCraftingPreviewElement((ItemStack)stack.getStack()));
            ((ItemCraftingPreviewElement)previewStack).setMissing(true);
            ((ItemCraftingPreviewElement)previewStack).addToCraft(stackListEntry.getStack().m_41613_());
        }
        for (StackListEntry<ItemStack> stackListEntry : info.getMissingFluids().getStacks()) {
            hash = API.instance().getFluidStackHashCode((FluidStack)stackListEntry.getStack());
            previewStack = mapFluids.computeIfAbsent(hash, key -> new FluidCraftingPreviewElement((FluidStack)stackListEntry.getStack()));
            ((FluidCraftingPreviewElement)previewStack).setMissing(true);
            ((FluidCraftingPreviewElement)previewStack).addToCraft(((FluidStack)stackListEntry.getStack()).getAmount());
        }
        for (ItemStack itemStack : ImmutableList.copyOf(info.getToCraft()).reverse()) {
            hash = API.instance().getItemStackHashCode(itemStack);
            previewStack = map.computeIfAbsent(hash, key -> new ItemCraftingPreviewElement(itemStack));
            ((ItemCraftingPreviewElement)previewStack).addToCraft(itemStack.m_41613_());
        }
        for (FluidStack fluidStack : ImmutableList.copyOf(info.getToCraftFluids()).reverse()) {
            hash = API.instance().getFluidStackHashCode(fluidStack);
            previewStack = mapFluids.computeIfAbsent(hash, key -> new FluidCraftingPreviewElement(fluidStack));
            ((FluidCraftingPreviewElement)previewStack).addToCraft(fluidStack.getAmount());
        }
        for (StackListEntry stackListEntry : info.getToTake().getStacks()) {
            hash = API.instance().getItemStackHashCode((ItemStack)stackListEntry.getStack());
            previewStack = map.computeIfAbsent(hash, key -> new ItemCraftingPreviewElement((ItemStack)stackListEntry.getStack()));
            ((ItemCraftingPreviewElement)previewStack).addAvailable(((ItemStack)stackListEntry.getStack()).m_41613_());
        }
        for (StackListEntry stackListEntry : info.getToTakeFluids().getStacks()) {
            hash = API.instance().getFluidStackHashCode((FluidStack)stackListEntry.getStack());
            previewStack = mapFluids.computeIfAbsent(hash, key -> new FluidCraftingPreviewElement((FluidStack)stackListEntry.getStack()));
            ((FluidCraftingPreviewElement)previewStack).addAvailable(((FluidStack)stackListEntry.getStack()).getAmount());
        }
        ArrayList<ICraftingPreviewElement> elements = new ArrayList<ICraftingPreviewElement>();
        elements.addAll(map.values());
        elements.addAll(mapFluids.values());
        return elements;
    }
}

