/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.storage.cache.InvalidateCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.CableBlock;
import com.refinedmods.refinedstorage.block.shape.ShapeCache;
import com.refinedmods.refinedstorage.blockentity.ExternalStorageBlockEntity;
import com.refinedmods.refinedstorage.container.ExternalStorageContainerMenu;
import com.refinedmods.refinedstorage.container.factory.BlockEntityMenuProvider;
import com.refinedmods.refinedstorage.render.ConstantsCable;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.CollisionUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class ExternalStorageBlock
extends CableBlock {
    private static final VoxelShape HEAD_NORTH = Shapes.m_83110_((VoxelShape)ExternalStorageBlock.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0), (VoxelShape)HOLDER_NORTH);
    private static final VoxelShape HEAD_EAST = Shapes.m_83110_((VoxelShape)ExternalStorageBlock.m_49796_((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (VoxelShape)HOLDER_EAST);
    private static final VoxelShape HEAD_SOUTH = Shapes.m_83110_((VoxelShape)ExternalStorageBlock.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), (VoxelShape)HOLDER_SOUTH);
    private static final VoxelShape HEAD_WEST = Shapes.m_83110_((VoxelShape)ExternalStorageBlock.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0), (VoxelShape)HOLDER_WEST);
    private static final VoxelShape HEAD_UP = Shapes.m_83110_((VoxelShape)ExternalStorageBlock.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape)HOLDER_UP);
    private static final VoxelShape HEAD_DOWN = Shapes.m_83110_((VoxelShape)ExternalStorageBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)HOLDER_DOWN);

    public ExternalStorageBlock() {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return ConstantsCable.addCoverVoxelShapes(ShapeCache.getOrCreate(state, s -> {
            VoxelShape shape = ExternalStorageBlock.getCableShape(s);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.getHeadShape((BlockState)s));
            return shape;
        }), world, pos);
    }

    private VoxelShape getHeadShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)this.getDirection().getProperty());
        if (direction == Direction.NORTH) {
            return HEAD_NORTH;
        }
        if (direction == Direction.EAST) {
            return HEAD_EAST;
        }
        if (direction == Direction.SOUTH) {
            return HEAD_SOUTH;
        }
        if (direction == Direction.WEST) {
            return HEAD_WEST;
        }
        if (direction == Direction.UP) {
            return HEAD_UP;
        }
        if (direction == Direction.DOWN) {
            return HEAD_DOWN;
        }
        return Shapes.m_83040_();
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ExternalStorageBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && CollisionUtils.isInBounds(this.getHeadShape(state), pos, hit.m_82450_())) {
            return NetworkUtils.attemptModify(level, pos, player, () -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), new BlockEntityMenuProvider<ExternalStorageBlockEntity>((Component)Component.m_237115_((String)"gui.refinedstorage.external_storage"), (blockEntity, windowId, inventory, p) -> new ExternalStorageContainerMenu((ExternalStorageBlockEntity)blockEntity, player, windowId), pos), (BlockPos)pos));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        INetworkNode node;
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_ && (node = NetworkUtils.getNodeFromBlockEntity(level.m_7702_(pos))) instanceof ExternalStorageNetworkNode && node.getNetwork() != null && fromPos.equals((Object)pos.m_121945_(((ExternalStorageNetworkNode)node).getDirection()))) {
            ((ExternalStorageNetworkNode)node).updateStorage(node.getNetwork(), InvalidateCause.NEIGHBOR_CHANGED);
        }
    }
}

