/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkNodeBlock
extends BaseBlock
implements EntityBlock {
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");

    protected NetworkNodeBlock(BlockBehaviour.Properties props) {
        super(props);
        if (this.hasConnectedState()) {
            this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        INetworkNode node;
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.f_46443_ && (node = API.instance().getNetworkNodeManager((ServerLevel)level).getNode(pos)) instanceof NetworkNode) {
            ((NetworkNode)node).setRedstonePowered(level.m_276867_(pos));
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IItemHandler handler;
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof NetworkNodeBlockEntity && (handler = ((NetworkNode)((NetworkNodeBlockEntity)blockEntity).getNode()).getDrops()) != null) {
            NonNullList drops = NonNullList.m_122779_();
            for (int i = 0; i < handler.getSlots(); ++i) {
                drops.add((Object)handler.getStackInSlot(i));
            }
            Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)drops);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    protected void onDirectionChanged(Level level, BlockPos pos, Direction newDirection) {
        Object node;
        super.onDirectionChanged(level, pos, newDirection);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof INetworkNodeProxy && (node = ((INetworkNodeProxy)blockEntity).getNode()) instanceof NetworkNode) {
            ((NetworkNode)node).onDirectionChanged(newDirection);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        if (this.hasConnectedState()) {
            builder.m_61104_(new Property[]{CONNECTED});
        }
    }

    public boolean hasConnectedState() {
        return false;
    }
}

